/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch7.configuration.XPackSecurityConfiguration;
import com.liferay.portal.search.elasticsearch7.internal.connection.BaseElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.OperationMode;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexFactory;
import com.liferay.portal.search.elasticsearch7.internal.settings.SettingsBuilder;
import com.liferay.portal.search.elasticsearch7.settings.SettingsContributor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration", "com.liferay.portal.search.elasticsearch7.configuration.XPackSecurityConfiguration"}, immediate=true, property={"operation.mode=REMOTE"}, service={ElasticsearchConnection.class})
public class RemoteElasticsearchConnection
extends BaseElasticsearchConnection {
    public static final String CONNECTION_ID = "REMOTE";
    @Reference
    protected Props props;
    protected volatile XPackSecurityConfiguration xPackSecurityConfiguration;
    private static final Log _log = LogFactoryUtil.getLog(RemoteElasticsearchConnection.class);
    private Set<String> _transportAddresses = new HashSet<String>();

    @Override
    public String getConnectionId() {
        return CONNECTION_ID;
    }

    @Override
    public OperationMode getOperationMode() {
        return OperationMode.REMOTE;
    }

    @Override
    @Reference(unbind="-")
    public void setIndexFactory(IndexFactory indexFactory) {
        super.setIndexFactory(indexFactory);
    }

    public void setTransportAddresses(Set<String> transportAddresses) {
        this._transportAddresses = transportAddresses;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.replaceConfigurations(properties);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(operation.mode=REMOTE)")
    protected void addSettingsContributor(SettingsContributor settingsContributor) {
        super.addSettingsContributor(settingsContributor);
    }

    protected void addTransportAddress(TransportClient transportClient, String transportAddress) throws UnknownHostException {
        String[] transportAddressParts = StringUtil.split((String)transportAddress, (String)":");
        String host = transportAddressParts[0];
        int port = GetterUtil.getInteger((String)transportAddressParts[1]);
        InetAddress inetAddress = InetAddressUtil.getInetAddressByName((String)host);
        transportClient.addTransportAddress(new TransportAddress(inetAddress, port));
    }

    protected void configureAuthentication(SettingsBuilder settingsBuilder) {
        String user = this.xPackSecurityConfiguration.username() + ":" + this.xPackSecurityConfiguration.password();
        settingsBuilder.put("xpack.security.user", user);
    }

    protected void configureCipherSuites(SettingsBuilder settingsBuilder) {
        String cipherSuites = GetterUtil.getString((String)SystemProperties.get((String)"jdk.tls.client.cipherSuites"));
        if (!Validator.isBlank((String)cipherSuites)) {
            settingsBuilder.put("xpack.security.transport.ssl.cipher_suites", cipherSuites);
        }
    }

    protected void configurePEMPaths(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("xpack.security.transport.ssl.certificate", this.xPackSecurityConfiguration.sslCertificatePath());
        settingsBuilder.putList("xpack.security.transport.ssl.certificate_authorities", this.xPackSecurityConfiguration.sslCertificateAuthoritiesPaths());
        settingsBuilder.put("xpack.security.transport.ssl.key", this.xPackSecurityConfiguration.sslKeyPath());
    }

    protected void configurePKCSPaths(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("xpack.security.transport.ssl.keystore.password", this.xPackSecurityConfiguration.sslKeystorePassword());
        settingsBuilder.put("xpack.security.transport.ssl.keystore.path", this.xPackSecurityConfiguration.sslKeystorePath());
        settingsBuilder.put("xpack.security.transport.ssl.truststore.password", this.xPackSecurityConfiguration.sslTruststorePassword());
        settingsBuilder.put("xpack.security.transport.ssl.truststore.path", this.xPackSecurityConfiguration.sslTruststorePath());
    }

    protected void configureSSL(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("xpack.security.transport.ssl.enabled", "true");
        settingsBuilder.put("xpack.security.transport.ssl.verification_mode", StringUtil.toLowerCase((String)this.xPackSecurityConfiguration.transportSSLVerificationMode()));
        String certificateFormat = this.xPackSecurityConfiguration.certificateFormat();
        if (certificateFormat.equals("PKCS#12")) {
            this.configurePKCSPaths(settingsBuilder);
        } else {
            this.configurePEMPaths(settingsBuilder);
        }
        this.configureCipherSuites(settingsBuilder);
        this.configureSupportedProtocols(settingsBuilder);
    }

    protected void configureSupportedProtocols(SettingsBuilder settingsBuilder) {
        String supportedProtocols = GetterUtil.getString((String)SystemProperties.get((String)"jdk.tls.client.protocols"));
        if (!Validator.isBlank((String)supportedProtocols)) {
            settingsBuilder.put("xpack.security.transport.ssl.supported_protocols", supportedProtocols);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Client createClient() {
        if (this._transportAddresses.isEmpty()) {
            throw new IllegalStateException("There must be at least one transport address");
        }
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        Class<?> clazz = this.getClass();
        thread.setContextClassLoader(clazz.getClassLoader());
        try {
            TransportClient transportClient = this.createTransportClient();
            for (String transportAddress : this._transportAddresses) {
                try {
                    this.addTransportAddress(transportClient, transportAddress);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to add transport address " + transportAddress), (Throwable)exception);
                }
            }
            TransportClient transportClient2 = transportClient;
            return transportClient2;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected TransportClient createTransportClient() {
        if (this.xPackSecurityConfiguration.requiresAuthentication()) {
            this.configureAuthentication(this.settingsBuilder);
        }
        if (this.xPackSecurityConfiguration.transportSSLEnabled()) {
            this.configureSSL(this.settingsBuilder);
        }
        Settings settings = this.settingsBuilder.build();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Settings: " + settings.toString()));
        }
        if (this.xPackSecurityConfiguration.requiresAuthentication() || this.xPackSecurityConfiguration.transportSSLEnabled()) {
            return new PreBuiltXPackTransportClient(settings, new Class[0]);
        }
        return new PreBuiltTransportClient(settings, new Class[0]);
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties) {
        this.close();
    }

    @Override
    protected void loadRequiredDefaultConfigurations() {
        this.settingsBuilder.put("client.transport.ignore_cluster_name", this.elasticsearchConfiguration.clientTransportIgnoreClusterName());
        this.settingsBuilder.put("client.transport.nodes_sampler_interval", this.elasticsearchConfiguration.clientTransportNodesSamplerInterval());
        this.settingsBuilder.put("client.transport.ping_timeout", this.elasticsearchConfiguration.clientTransportPingTimeout());
        this.settingsBuilder.put("client.transport.sniff", this.elasticsearchConfiguration.clientTransportSniff());
        this.settingsBuilder.put("cluster.name", this.elasticsearchConfiguration.clusterName());
        this.settingsBuilder.put("request.headers.X-Found-Cluster", this.elasticsearchConfiguration.clusterName());
    }

    @Modified
    protected synchronized void modified(Map<String, Object> properties) {
        this.replaceConfigurations(properties);
        if (this.isConnected()) {
            this.close();
        }
        if (!this.isConnected() && this.elasticsearchConfiguration.operationMode() == com.liferay.portal.search.elasticsearch7.configuration.OperationMode.REMOTE) {
            this.connect();
        }
    }

    @Override
    protected void removeSettingsContributor(SettingsContributor settingsContributor) {
        super.removeSettingsContributor(settingsContributor);
    }

    protected void replaceConfigurations(Map<String, Object> properties) {
        this.elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this.xPackSecurityConfiguration = (XPackSecurityConfiguration)ConfigurableUtil.createConfigurable(XPackSecurityConfiguration.class, properties);
        Object[] transportAddresses = this.elasticsearchConfiguration.transportAddresses();
        this.setTransportAddresses(SetUtil.fromArray((Object[])transportAddresses));
    }
}

