/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.ccr;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.search.ccr.CrossClusterReplicationHelper;
import com.liferay.portal.search.configuration.CrossClusterReplicationConfigurationWrapper;
import com.liferay.portal.search.configuration.ElasticsearchConnectionConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.CcrClient;
import org.elasticsearch.client.ClusterClient;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.ccr.FollowInfoRequest;
import org.elasticsearch.client.ccr.FollowInfoResponse;
import org.elasticsearch.client.ccr.PauseFollowRequest;
import org.elasticsearch.client.ccr.PutFollowRequest;
import org.elasticsearch.client.ccr.UnfollowRequest;
import org.elasticsearch.client.indices.CloseIndexRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(immediate=true, service={CrossClusterReplicationHelper.class})
public class CrossClusterReplicationHelperImpl
implements CrossClusterReplicationHelper {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected volatile CrossClusterReplicationConfigurationWrapper crossClusterReplicationConfigurationWrapper;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected volatile ElasticsearchConnectionConfigurationWrapper elasticsearchConnectionConfigurationWrapper;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    private static final Log _log = LogFactoryUtil.getLog(CrossClusterReplicationHelperImpl.class);

    public void addRemoteCluster(String remoteClusterAlias, String remoteClusterSeedNodeTransportAddress, String localClusterConnectionId) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Adding remote cluster ", remoteClusterAlias, " for connection ", localClusterConnectionId}));
        }
        this.executeWithRestHighLevelClient(localClusterConnectionId, restHighLevelClient -> {
            try {
                this._updateSettings((RestHighLevelClient)restHighLevelClient, remoteClusterAlias, remoteClusterSeedNodeTransportAddress);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to add the remote cluster ", remoteClusterAlias, " for connection ", localClusterConnectionId}), (Throwable)exception);
            }
        });
    }

    public void deleteRemoteCluster(String remoteClusterAlias, String localClusterConnectionId) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Removing remote cluster ", remoteClusterAlias, " for connection ", localClusterConnectionId}));
        }
        this.executeWithRestHighLevelClient(localClusterConnectionId, restHighLevelClient -> {
            try {
                this._updateSettings((RestHighLevelClient)restHighLevelClient, remoteClusterAlias, null);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to remove the remote cluster ", remoteClusterAlias, " for connection ", localClusterConnectionId}), (Throwable)exception);
            }
        });
    }

    public void follow(String indexName) {
        if (!this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Not following index " + indexName + " because cross-cluster replication is not enabled"));
            }
            return;
        }
        for (String localClusterConnectionId : this.elasticsearchConnectionManager.getLocalClusterConnectionIds()) {
            this.follow(this.crossClusterReplicationConfigurationWrapper.getRemoteClusterAlias(), indexName, localClusterConnectionId);
        }
    }

    public void follow(String remoteClusterAlias, String indexName, String localClusterConnectionId) {
        this.executeWithRestHighLevelClient(localClusterConnectionId, restHighLevelClient -> {
            if (this._isFollowingActive(indexName, (RestHighLevelClient)restHighLevelClient)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"The ", indexName, " index is already being followed for ", "connection ", localClusterConnectionId}));
                }
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Executing follow request for the ", indexName, " index with connection ", localClusterConnectionId}));
            }
            try {
                this._putFollow(remoteClusterAlias, indexName, (RestHighLevelClient)restHighLevelClient);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to follow the ", indexName, " index in the ", remoteClusterAlias, " cluster for connection ", localClusterConnectionId}), (Throwable)exception);
            }
        });
    }

    public void unfollow(String indexName) {
        if (!this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Not unfollowing index " + indexName + " because cross-cluster replication is not enabled"));
            }
            return;
        }
        for (String localClusterConnectionId : this.elasticsearchConnectionManager.getLocalClusterConnectionIds()) {
            this.unfollow(indexName, localClusterConnectionId);
        }
    }

    public void unfollow(String indexName, String localClusterConnectionId) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Executing unfollow requests for the ", indexName, " index with connection ", localClusterConnectionId}));
        }
        this.executeWithRestHighLevelClient(localClusterConnectionId, restHighLevelClient -> {
            try {
                this._pauseFollow(indexName, (RestHighLevelClient)restHighLevelClient);
                this._closeIndex(indexName, (RestHighLevelClient)restHighLevelClient);
                this._unfollow(indexName, (RestHighLevelClient)restHighLevelClient);
                this._deleteIndex(indexName, (RestHighLevelClient)restHighLevelClient);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to unfollow the ", indexName, " index for connection ", localClusterConnectionId}), (Throwable)exception);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWithRestHighLevelClient(String connectionId, Consumer<RestHighLevelClient> consumer) {
        RestHighLevelClient restHighLevelClient = this._createRestHighLevelClient(connectionId);
        try {
            consumer.accept(restHighLevelClient);
        }
        finally {
            block8: {
                try {
                    restHighLevelClient.close();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)("Unable to close the REST client for connection " + connectionId), (Throwable)exception);
                }
            }
        }
    }

    private void _closeIndex(String indexName, RestHighLevelClient restHighLevelClient) throws Exception {
        IndicesClient indices = restHighLevelClient.indices();
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(new String[]{indexName});
        indices.close(closeIndexRequest, RequestOptions.DEFAULT);
    }

    private void _configureSecurity(RestClientBuilder restClientBuilder, String connectionId) {
        restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            if (this.elasticsearchConnectionConfigurationWrapper.isAuthenticationEnabled(connectionId)) {
                httpClientBuilder.setDefaultCredentialsProvider(this._createCredentialsProvider(connectionId));
            }
            if (this.elasticsearchConnectionConfigurationWrapper.isTransportSSLEnabled(connectionId)) {
                httpClientBuilder.setSSLContext(this._createSSLContext(connectionId));
            }
            return httpClientBuilder;
        });
    }

    private CredentialsProvider _createCredentialsProvider(String connectionId) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.elasticsearchConnectionConfigurationWrapper.getUsername(connectionId), this.elasticsearchConnectionConfigurationWrapper.getPassword(connectionId)));
        return credentialsProvider;
    }

    private RestHighLevelClient _createRestHighLevelClient(String connectionId) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)this.elasticsearchConnectionConfigurationWrapper.getNetworkHostAddress(connectionId))});
        this._configureSecurity(restClientBuilder, connectionId);
        return new RestHighLevelClient(restClientBuilder);
    }

    private SSLContext _createSSLContext(String connectionId) {
        try {
            Path path = Paths.get(this.elasticsearchConnectionConfigurationWrapper.getSslTruststorePath(connectionId), new String[0]);
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            KeyStore keyStore = KeyStore.getInstance(this.elasticsearchConnectionConfigurationWrapper.getCertificateFormat(connectionId));
            String truststorePassword = this.elasticsearchConnectionConfigurationWrapper.getSslTruststorePassword(connectionId);
            keyStore.load(is, truststorePassword.toCharArray());
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            sslContextBuilder.loadKeyMaterial(keyStore, truststorePassword.toCharArray());
            sslContextBuilder.loadTrustMaterial(keyStore, null);
            return sslContextBuilder.build();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void _deleteIndex(String indexName, RestHighLevelClient restHighLevelClient) throws Exception {
        IndicesClient indices = restHighLevelClient.indices();
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
        indices.delete(deleteIndexRequest, RequestOptions.DEFAULT);
    }

    private boolean _isFollowingActive(String indexName, RestHighLevelClient restHighLevelClient) {
        try {
            CcrClient ccrClient = restHighLevelClient.ccr();
            FollowInfoRequest followInfoRequest = new FollowInfoRequest(indexName);
            FollowInfoResponse followInfoResponse = ccrClient.getFollowInfo(followInfoRequest, RequestOptions.DEFAULT);
            List followerInfos = followInfoResponse.getInfos();
            FollowInfoResponse.FollowerInfo followerInfo = (FollowInfoResponse.FollowerInfo)followerInfos.get(0);
            FollowInfoResponse.Status status = followerInfo.getStatus();
            if (status == FollowInfoResponse.Status.ACTIVE) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void _pauseFollow(String indexName, RestHighLevelClient restHighLevelClient) throws Exception {
        CcrClient ccrClient = restHighLevelClient.ccr();
        PauseFollowRequest pauseFollowRequest = new PauseFollowRequest(indexName);
        ccrClient.pauseFollow(pauseFollowRequest, RequestOptions.DEFAULT);
    }

    private void _putFollow(String remoteClusterAlias, String indexName, RestHighLevelClient restHighLevelClient) throws Exception {
        CcrClient ccrClient = restHighLevelClient.ccr();
        PutFollowRequest putFollowRequest = new PutFollowRequest(remoteClusterAlias, indexName, indexName, ActiveShardCount.from((int)1));
        ccrClient.putFollow(putFollowRequest, RequestOptions.DEFAULT);
    }

    private void _unfollow(String indexName, RestHighLevelClient restHighLevelClient) throws Exception {
        CcrClient ccrClient = restHighLevelClient.ccr();
        UnfollowRequest unfollowRequest = new UnfollowRequest(indexName);
        ccrClient.unfollow(unfollowRequest, RequestOptions.DEFAULT);
    }

    private void _updateSettings(RestHighLevelClient restHighLevelClient, String remoteClusterAlias, String remoteClusterSeedNodeTransportAddress) throws Exception {
        ClusterClient clusterClient = restHighLevelClient.cluster();
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = new ClusterUpdateSettingsRequest();
        clusterUpdateSettingsRequest.persistentSettings((Map)HashMapBuilder.put((Object)("cluster.remote." + remoteClusterAlias + ".seeds"), (Object)remoteClusterSeedNodeTransportAddress).build());
        clusterClient.putSettings(clusterUpdateSettingsRequest, RequestOptions.DEFAULT);
    }
}

