/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.suggest.PhraseSuggester;
import com.liferay.portal.kernel.search.suggest.QuerySuggester;
import com.liferay.portal.kernel.search.suggest.Suggester;
import com.liferay.portal.kernel.search.suggest.SuggesterResult;
import com.liferay.portal.kernel.search.suggest.SuggesterResults;
import com.liferay.portal.kernel.search.suggest.TermSuggester;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SuggestSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SuggestSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SuggestSearchResult;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={QuerySuggester.class})
public class ElasticsearchQuerySuggester
implements QuerySuggester {
    private static final String _KEY_WORD_REQUEST_NAME = "keywordQueryRequest";
    private static final String _SPELL_CHECK_REQUEST_NAME = "spellCheckRequest";
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchQuerySuggester.class);
    private IndexNameBuilder _indexNameBuilder;
    private Localization _localization;
    private SearchEngineAdapter _searchEngineAdapter;

    public String spellCheckKeywords(SearchContext searchContext) {
        Suggester suggester = this.createSpellCheckSuggester(searchContext, 1);
        SuggestSearchResponse suggestSearchResponse = this.executeSuggestSearchRequest(suggester, searchContext);
        if (suggestSearchResponse == null) {
            return "";
        }
        SuggestSearchResult suggestSearchResult = suggestSearchResponse.getSuggesterResult(_SPELL_CHECK_REQUEST_NAME);
        if (suggestSearchResult == null) {
            return "";
        }
        List<String> words = this.getHighestRankedSuggestResults(suggestSearchResult);
        return StringUtil.merge(words, (String)" ");
    }

    public Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) {
        Suggester suggester = this.createSpellCheckSuggester(searchContext, max);
        SuggestSearchResponse suggestSearchResponse = this.executeSuggestSearchRequest(suggester, searchContext);
        if (suggestSearchResponse == null) {
            return Collections.emptyMap();
        }
        SuggestSearchResult suggestSearchResult = suggestSearchResponse.getSuggesterResult(_SPELL_CHECK_REQUEST_NAME);
        if (suggestSearchResult == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> results = new LinkedHashMap<String, List<String>>();
        List suggestSearchResultEntries = suggestSearchResult.getEntries();
        suggestSearchResultEntries.forEach(suggestSearchResultEntry -> {
            List suggestSearchResultEntryOptions = suggestSearchResultEntry.getOptions();
            String keyword = suggestSearchResultEntry.getText();
            List wordsList = results.computeIfAbsent(keyword, keywords -> new ArrayList());
            suggestSearchResultEntryOptions.forEach(suggestSearchResultEntryOption -> {
                String word = suggestSearchResultEntryOption.getText();
                if (!wordsList.contains(word)) {
                    wordsList.add(word);
                }
            });
        });
        return results;
    }

    public SuggesterResults suggest(SearchContext searchContext, Suggester suggester) {
        SuggestSearchResponse suggestSearchResponse = this.executeSuggestSearchRequest(suggester, searchContext);
        if (suggestSearchResponse == null) {
            return new SuggesterResults();
        }
        return this.translate(suggestSearchResponse);
    }

    public String[] suggestKeywordQueries(SearchContext searchContext, int max) {
        PhraseSuggester suggester = this.createQuerySuggester(searchContext, max);
        SuggestSearchResponse suggestSearchResponse = this.executeSuggestSearchRequest((Suggester)suggester, searchContext);
        if (suggestSearchResponse == null) {
            return StringPool.EMPTY_ARRAY;
        }
        SuggestSearchResult suggestSearchResult = suggestSearchResponse.getSuggesterResult(_KEY_WORD_REQUEST_NAME);
        if (suggestSearchResult == null) {
            return StringPool.EMPTY_ARRAY;
        }
        List<String> keywordQueries = this.getHighestRankedSuggestResults(suggestSearchResult);
        return keywordQueries.toArray(new String[0]);
    }

    protected PhraseSuggester createQuerySuggester(SearchContext searchContext, int max) {
        Localization localization = this.getLocalization();
        String field = localization.getLocalizedName("keywordSearch", searchContext.getLanguageId());
        PhraseSuggester phraseSuggester = new PhraseSuggester(_KEY_WORD_REQUEST_NAME, field, searchContext.getKeywords());
        phraseSuggester.setSize(Integer.valueOf(max));
        return phraseSuggester;
    }

    protected Suggester createSpellCheckSuggester(SearchContext searchContext, int max) {
        Localization localization = this.getLocalization();
        String field = localization.getLocalizedName("spellCheckWord", searchContext.getLanguageId());
        TermSuggester termSuggester = new TermSuggester(_SPELL_CHECK_REQUEST_NAME, field, searchContext.getKeywords());
        termSuggester.setSize(Integer.valueOf(max));
        return termSuggester;
    }

    protected SuggestSearchResponse executeSuggestSearchRequest(Suggester suggester, SearchContext searchContext) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            SuggestSearchRequest suggestSearchRequest = new SuggestSearchRequest(new String[]{this._indexNameBuilder.getIndexName(searchContext.getCompanyId())});
            suggestSearchRequest.addSuggester(suggester);
            SuggestSearchResponse suggestSearchResponse = (SuggestSearchResponse)this._searchEngineAdapter.execute((SearchRequest)suggestSearchRequest);
            return suggestSearchResponse;
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable;
            String message = runtimeException.getMessage();
            if (!message.contains("no mapping found for field") && (throwable = runtimeException.getCause()) != null) {
                message = throwable.getMessage();
            }
            if (message.contains("no mapping found for field")) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"No dictionary indexed", (Throwable)runtimeException);
                }
                SuggestSearchResponse suggestSearchResponse = null;
                return suggestSearchResponse;
            }
            throw runtimeException;
        }
        finally {
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)("Spell checked keywords in " + stopWatch.getTime() + "ms"));
            }
        }
    }

    protected List<String> getHighestRankedSuggestResults(SuggestSearchResult suggestSearchResult) {
        ArrayList<String> texts = new ArrayList<String>();
        List suggestSearchResultEntries = suggestSearchResult.getEntries();
        suggestSearchResultEntries.forEach(suggestSearchResultEntry -> {
            List suggestSearchResultEntryOptions = suggestSearchResultEntry.getOptions();
            for (SuggestSearchResult.Entry.Option suggestSearchResultEntryOption : suggestSearchResultEntryOptions) {
                texts.add(suggestSearchResultEntryOption.getText());
            }
        });
        return texts;
    }

    protected Localization getLocalization() {
        if (this._localization != null) {
            return this._localization;
        }
        return LocalizationUtil.getLocalization();
    }

    @Reference(unbind="-")
    protected void setIndexNameBuilder(IndexNameBuilder indexNameBuilder) {
        this._indexNameBuilder = indexNameBuilder;
    }

    protected void setLocalization(Localization localization) {
        this._localization = localization;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setSearchEngineAdapter(SearchEngineAdapter searchEngineAdapter) {
        this._searchEngineAdapter = searchEngineAdapter;
    }

    protected SuggesterResults translate(SuggestSearchResponse suggestSearchResponse) {
        SuggesterResults suggesterResults = new SuggesterResults();
        Collection suggestSearchResults = suggestSearchResponse.getSuggestSearchResults();
        suggestSearchResults.forEach(suggestSearchResult -> {
            SuggesterResult suggesterResult = new SuggesterResult(suggestSearchResult.getName());
            suggesterResults.addSuggesterResult(suggesterResult);
            List suggestSearchResultEntries = suggestSearchResult.getEntries();
            suggestSearchResultEntries.forEach(suggestSearchResultEntry -> {
                SuggesterResult.Entry suggesterResultEntry = new SuggesterResult.Entry(suggestSearchResultEntry.getText());
                suggesterResult.addEntry(suggesterResultEntry);
                List suggestSearchResultEntryOptions = suggestSearchResultEntry.getOptions();
                suggestSearchResultEntryOptions.forEach(suggestSearchResultEntryOption -> {
                    SuggesterResult.Entry.Option suggesterResultEntryOption = new SuggesterResult.Entry.Option(suggestSearchResultEntryOption.getText(), suggestSearchResultEntryOption.getScore());
                    suggesterResultEntry.addOption(suggesterResultEntryOption);
                    suggesterResultEntryOption.setFrequency(suggestSearchResultEntryOption.getFrequency());
                    suggesterResultEntryOption.setHighlightedText(suggestSearchResultEntryOption.getHighlightedText());
                });
            });
        });
        return suggesterResults;
    }
}

