/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.suggest;

import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.kernel.search.suggest.PhraseSuggester;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.suggest.BaseSuggesterTranslatorImpl;
import com.liferay.portal.search.elasticsearch7.internal.suggest.PhraseSuggesterTranslator;
import java.util.Set;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGeneratorBuilder;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={PhraseSuggesterTranslator.class})
public class PhraseSuggesterTranslatorImpl
extends BaseSuggesterTranslatorImpl
implements PhraseSuggesterTranslator {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(search.engine.impl=Elasticsearch)")
    protected volatile QueryTranslator<QueryBuilder> queryTranslator;

    @Override
    public SuggestionBuilder translate(PhraseSuggester phraseSuggester) {
        PhraseSuggestionBuilder phraseSuggestionBuilder = SuggestBuilders.phraseSuggestion((String)phraseSuggester.getField());
        if (Validator.isNotNull((String)phraseSuggester.getAnalyzer())) {
            phraseSuggestionBuilder.analyzer(phraseSuggester.getAnalyzer());
        }
        this.translate(phraseSuggester.getCandidateGenerators(), phraseSuggestionBuilder);
        this.translate(phraseSuggester.getCollate(), phraseSuggestionBuilder);
        if (phraseSuggester.getConfidence() != null) {
            phraseSuggestionBuilder.confidence(phraseSuggester.getConfidence().floatValue());
        }
        if (phraseSuggester.isForceUnigrams() != null) {
            phraseSuggestionBuilder.forceUnigrams(phraseSuggester.isForceUnigrams().booleanValue());
        }
        if (phraseSuggester.getGramSize() != null) {
            phraseSuggestionBuilder.gramSize(phraseSuggester.getGramSize().intValue());
        }
        if (phraseSuggester.getMaxErrors() != null) {
            phraseSuggestionBuilder.maxErrors(phraseSuggester.getMaxErrors().floatValue());
        }
        if (Validator.isNotNull((String)phraseSuggester.getPostHighlightFilter()) && Validator.isNotNull((String)phraseSuggester.getPreHighlightFilter())) {
            phraseSuggestionBuilder.highlight(phraseSuggester.getPreHighlightFilter(), phraseSuggester.getPostHighlightFilter());
        }
        if (phraseSuggester.getRealWordErrorLikelihood() != null) {
            phraseSuggestionBuilder.realWordErrorLikelihood(phraseSuggester.getRealWordErrorLikelihood().floatValue());
        }
        if (phraseSuggester.getSeparator() != null) {
            phraseSuggestionBuilder.separator(phraseSuggester.getSeparator());
        }
        if (phraseSuggester.getShardSize() != null) {
            phraseSuggestionBuilder.shardSize(phraseSuggester.getShardSize());
        }
        if (phraseSuggester.getSize() != null) {
            phraseSuggestionBuilder.size(phraseSuggester.getSize().intValue());
        }
        if (phraseSuggester.getTokenLimit() != null) {
            phraseSuggestionBuilder.tokenLimit(phraseSuggester.getTokenLimit().intValue());
        }
        phraseSuggestionBuilder.text(phraseSuggester.getValue());
        return phraseSuggestionBuilder;
    }

    protected void translate(PhraseSuggester.Collate collate, PhraseSuggestionBuilder phraseSuggestionBuilder) {
        if (collate != null && this.queryTranslator != null) {
            QueryBuilder queryBuilder = (QueryBuilder)this.queryTranslator.translate(collate.getQuery(), null);
            phraseSuggestionBuilder.collateParams(collate.getParams());
            if (collate.isPrune() != null) {
                phraseSuggestionBuilder.collatePrune(collate.isPrune().booleanValue());
            }
            phraseSuggestionBuilder.collateQuery(queryBuilder.toString());
        }
    }

    protected void translate(Set<PhraseSuggester.CandidateGenerator> candidateGenerators, PhraseSuggestionBuilder phraseSuggestionBuilder) {
        for (PhraseSuggester.CandidateGenerator candidateGenerator : candidateGenerators) {
            DirectCandidateGeneratorBuilder directCandidateGenerator = new DirectCandidateGeneratorBuilder(candidateGenerator.getField());
            if (candidateGenerator.getAccuracy() != null) {
                directCandidateGenerator.accuracy(candidateGenerator.getAccuracy().floatValue());
            }
            if (candidateGenerator.getMaxEdits() != null) {
                directCandidateGenerator.maxEdits(candidateGenerator.getMaxEdits());
            }
            if (candidateGenerator.getMaxInspections() != null) {
                directCandidateGenerator.maxInspections(candidateGenerator.getMaxInspections());
            }
            if (candidateGenerator.getMaxTermFreq() != null) {
                directCandidateGenerator.maxTermFreq((float)candidateGenerator.getMaxTermFreq().intValue());
            }
            if (candidateGenerator.getMinWordLength() != null) {
                directCandidateGenerator.minWordLength(candidateGenerator.getMinWordLength().intValue());
            }
            if (candidateGenerator.getMinDocFreq() != null) {
                directCandidateGenerator.minDocFreq((float)candidateGenerator.getMinDocFreq().intValue());
            }
            if (candidateGenerator.getPrefixLength() != null) {
                directCandidateGenerator.prefixLength(candidateGenerator.getPrefixLength().intValue());
            }
            if (Validator.isNotNull((String)candidateGenerator.getPostFilterAnalyzer())) {
                directCandidateGenerator.postFilter(candidateGenerator.getPostFilterAnalyzer());
            }
            if (Validator.isNotNull((String)candidateGenerator.getPreFilterAnalyzer())) {
                directCandidateGenerator.preFilter(candidateGenerator.getPreFilterAnalyzer());
            }
            if (candidateGenerator.getSize() != null) {
                directCandidateGenerator.size(candidateGenerator.getSize().intValue());
            }
            if (candidateGenerator.getSort() != null) {
                directCandidateGenerator.sort(this.translate(candidateGenerator.getSort()));
            }
            if (candidateGenerator.getStringDistance() != null) {
                directCandidateGenerator.stringDistance(this.translate(candidateGenerator.getStringDistance()));
            }
            if (candidateGenerator.getSuggestMode() != null) {
                directCandidateGenerator.suggestMode(this.translate(candidateGenerator.getSuggestMode()));
            }
            phraseSuggestionBuilder.addCandidateGenerator((PhraseSuggestionBuilder.CandidateGenerator)directCandidateGenerator);
        }
    }
}

