/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.portal.kernel.util.OSDetector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UncompressUtil {
    private static final int _CHARS_BUFFER_SIZE = 8192;
    private static final Logger _logger = LogManager.getLogger(UncompressUtil.class);

    public static void unarchive(Path tarGzFilePath, Path destinationDirectoryPath) throws IOException {
        Files.createDirectories(destinationDirectoryPath, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(tarGzFilePath, new OpenOption[0]);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 8192);
             GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream((InputStream)bufferedInputStream);
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)gzipCompressorInputStream);){
            TarArchiveEntry tarArchiveEntry = null;
            while ((tarArchiveEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
                if (tarArchiveInputStream.canReadEntryData((ArchiveEntry)tarArchiveEntry)) {
                    Path path = destinationDirectoryPath.resolve(tarArchiveEntry.getName());
                    if (tarArchiveEntry.isDirectory()) {
                        Files.createDirectory(path, new FileAttribute[0]);
                    } else {
                        Files.copy((InputStream)tarArchiveInputStream, path, new CopyOption[0]);
                    }
                    UncompressUtil._setFilePermission(path);
                    continue;
                }
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn("Unable to read " + tarArchiveEntry.getName() + " from tar archive entry");
            }
        }
    }

    public static void unzip(Path zipFilePath, Path destinationDirectoryPath) throws IOException {
        Files.createDirectories(destinationDirectoryPath, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(zipFilePath, new OpenOption[0]);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Path path = destinationDirectoryPath.resolve(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectory(path, new FileAttribute[0]);
                } else {
                    Files.copy(zipInputStream, path, new CopyOption[0]);
                }
                UncompressUtil._setFilePermission(path);
            }
        }
    }

    private static void _setFilePermission(Path path) throws IOException {
        if (OSDetector.isWindows()) {
            File file = path.toFile();
            file.setExecutable(true);
            file.setReadable(true);
            file.setWritable(true);
        } else {
            Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rwxrwxrwx"));
        }
    }
}

