/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationObserver;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.configuration.OperationModeResolver;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionBuilder;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchInstancePaths;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchInstancePathsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ProcessExecutorPathsImpl;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Sidecar;
import com.liferay.portal.search.elasticsearch7.settings.SettingsContributor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(enabled=true, immediate=true, service={})
public class SidecarManager
implements ElasticsearchConfigurationObserver {
    @Reference
    protected ClusterExecutor clusterExecutor;
    @Reference
    protected volatile ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected OperationModeResolver operationModeResolver;
    @Reference
    protected ProcessExecutor processExecutor;
    @Reference
    protected Props props;
    private static final Log _log = LogFactoryUtil.getLog(SidecarManager.class);
    private final Set<SettingsContributor> _settingsContributors = new ConcurrentSkipListSet<SettingsContributor>();
    private Sidecar _sidecar;

    @Override
    public int compareTo(ElasticsearchConfigurationObserver elasticsearchConfigurationObserver) {
        return this.elasticsearchConfigurationWrapper.compare(this, elasticsearchConfigurationObserver);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void onElasticsearchConfigurationUpdate() {
        this.applyConfigurations();
    }

    @Activate
    protected void activate() {
        this.elasticsearchConfigurationWrapper.register(this);
        this.applyConfigurations();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(operation.mode=SIDECAR)")
    protected void addSettingsContributor(SettingsContributor settingsContributor) {
        this._settingsContributors.add(settingsContributor);
    }

    protected void applyConfigurations() {
        if (this.operationModeResolver.isProductionModeEnabled()) {
            this.elasticsearchConnectionManager.removeElasticsearchConnection("__SIDECAR__");
        } else {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(7);
                sb.append("Liferay automatically starts a child process of ");
                sb.append("Elasticsearch named sidecar for convenient ");
                sb.append("development and demonstration purposes. Do NOT ");
                sb.append("use sidecar in production. Refer to the ");
                sb.append("documentation for details on the limitations of ");
                sb.append("sidecar and instructions on configuring a remote ");
                sb.append("Elasticsearch connection in the Control Panel.");
                _log.warn((Object)sb.toString());
            }
            if (this._sidecar != null) {
                this._sidecar.stop();
            }
            this._sidecar = new Sidecar(this.clusterExecutor, this.elasticsearchConfigurationWrapper, this.getElasticsearchInstancePaths(), this.processExecutor, new ProcessExecutorPathsImpl(this.props), this._settingsContributors);
            ElasticsearchConnectionBuilder elasticsearchConnectionBuilder = new ElasticsearchConnectionBuilder();
            elasticsearchConnectionBuilder.active(true).connectionId("__SIDECAR__").postCloseRunnable(this._sidecar::stop).preConnectElasticsearchConnectionConsumer(elasticsearchConnection -> {
                this._sidecar.start();
                elasticsearchConnection.setNetworkHostAddresses(new String[]{this._sidecar.getNetworkHostAddress()});
            });
            this.elasticsearchConnectionManager.addElasticsearchConnection(elasticsearchConnectionBuilder.build());
        }
    }

    @Deactivate
    protected void deactivate() {
        this.elasticsearchConfigurationWrapper.unregister(this);
    }

    protected ElasticsearchInstancePaths getElasticsearchInstancePaths() {
        ElasticsearchInstancePathsBuilder elasticsearchInstancePathsBuilder = new ElasticsearchInstancePathsBuilder();
        Path workPath = Paths.get(this.props.get("liferay.home"), new String[0]);
        Path dataPath = workPath.resolve("data/elasticsearch7");
        return elasticsearchInstancePathsBuilder.dataPath(dataPath).homePath(this.resolveHomePath(workPath)).workPath(workPath).build();
    }

    protected void removeSettingsContributor(SettingsContributor settingsContributor) {
        this._settingsContributors.remove(settingsContributor);
    }

    protected Path resolveHomePath(Path path) {
        Path absoluteSidecarHomePath;
        String sidecarHome = this.elasticsearchConfigurationWrapper.sidecarHome();
        Path relativeSidecarHomePath = path.resolve(sidecarHome);
        if (!Files.isDirectory(relativeSidecarHomePath, new LinkOption[0]) && Files.isDirectory(absoluteSidecarHomePath = Paths.get(sidecarHome, new String[0]), new LinkOption[0])) {
            return absoluteSidecarHomePath;
        }
        return relativeSidecarHomePath;
    }
}

