/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ClassPathUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.process.ProcessLog;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchInstancePaths;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchInstanceSettingsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.connection.HttpPortRange;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ClassModificationUtil;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Distribution;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Elasticsearch730Distribution;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Elasticsearch770Distribution;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Elasticsearch790Distribution;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ElasticsearchInstaller;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.PathUtil;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ProcessExecutorPaths;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.SidecarComponentUtil;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.SidecarMainProcessCallable;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.StartSidecarProcessCallable;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.StopSidecarProcessCallable;
import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.search.elasticsearch7.settings.SettingsContributor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.settings.Settings;

public class Sidecar {
    private static final Log _log = LogFactoryUtil.getLog(Sidecar.class);
    private String _address;
    private final ClusterExecutor _clusterExecutor;
    private final Path _dataHomePath;
    private final ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    private final ElasticsearchInstancePaths _elasticsearchInstancePaths;
    private ProcessChannel<Serializable> _processChannel;
    private final ProcessExecutor _processExecutor;
    private final ProcessExecutorPaths _processExecutorPaths;
    private FutureListener<Serializable> _restartFutureListener;
    private final Collection<SettingsContributor> _settingsContributors;
    private final Path _sidecarHomePath;
    private Path _sidecarTempDirPath;

    public Sidecar(ClusterExecutor clusterExecutor, ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper, ElasticsearchInstancePaths elasticsearchInstancePaths, ProcessExecutor processExecutor, ProcessExecutorPaths processExecutorPaths, Collection<SettingsContributor> settingsContributors) {
        this._clusterExecutor = clusterExecutor;
        this._dataHomePath = elasticsearchInstancePaths.getDataPath();
        this._elasticsearchConfigurationWrapper = elasticsearchConfigurationWrapper;
        this._elasticsearchInstancePaths = elasticsearchInstancePaths;
        this._processExecutor = processExecutor;
        this._processExecutorPaths = processExecutorPaths;
        this._settingsContributors = settingsContributors;
        this._sidecarHomePath = elasticsearchInstancePaths.getHomePath();
    }

    public String getNetworkHostAddress() {
        return this._address;
    }

    public void start() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Sidecar Elasticsearch starting");
        }
        this._installElasticsearchIfNeeded();
        ProcessChannel<Serializable> processChannel = this.executeSidecarMainProcess();
        RestartFutureListener futureListener = new RestartFutureListener();
        Sidecar.addFutureListener(processChannel, futureListener);
        String address = this.startElasticsearch(processChannel);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Sidecar Elasticsearch ", this.getNodeName(), " started at ", address}));
        }
        this._address = address;
        this._processChannel = processChannel;
        this._restartFutureListener = futureListener;
    }

    public void stop() {
        block5: {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Stopping sidecar Elasticsearch");
            }
            PathUtil.deleteDir(this._sidecarTempDirPath);
            if (this._processChannel == null) {
                return;
            }
            NoticeableFuture noticeableFuture = this._processChannel.getProcessNoticeableFuture();
            noticeableFuture.removeFutureListener(this._restartFutureListener);
            this._processChannel.write((ProcessCallable)new StopSidecarProcessCallable());
            try {
                noticeableFuture.get(this._elasticsearchConfigurationWrapper.sidecarShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                if (noticeableFuture.isDone()) break block5;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Forcibly shutdown sidecar Elasticsearch process ", "because it did not shut down in ", this._elasticsearchConfigurationWrapper.sidecarShutdownTimeout(), " ms"}));
                }
                noticeableFuture.cancel(true);
            }
        }
        this._processChannel = null;
    }

    protected static void addFutureListener(ProcessChannel<Serializable> processChannel, FutureListener<Serializable> futureListener) {
        NoticeableFuture noticeableFuture = processChannel.getProcessNoticeableFuture();
        noticeableFuture.addFutureListener(futureListener);
    }

    protected static boolean fileNameContains(Path path, String s) {
        String name = String.valueOf(path.getFileName());
        return name.contains(s);
    }

    protected static String waitForPublishedAddress(NoticeableFuture<String> noticeableFuture) throws Exception {
        try {
            return (String)noticeableFuture.get();
        }
        catch (ExecutionException executionException) {
            throw (Exception)executionException.getCause();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    protected void consumeProcessLog(ProcessLog processLog) {
        if (ProcessLog.Level.DEBUG == processLog.getLevel()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)processLog.getMessage(), processLog.getThrowable());
            }
        } else if (ProcessLog.Level.INFO == processLog.getLevel()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)processLog.getMessage(), processLog.getThrowable());
            }
        } else if (ProcessLog.Level.WARN == processLog.getLevel()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)processLog.getMessage(), processLog.getThrowable());
            }
        } else {
            _log.error((Object)processLog.getMessage(), processLog.getThrowable());
        }
    }

    protected ProcessChannel<Serializable> executeSidecarMainProcess() {
        if (!Files.isDirectory(this._sidecarHomePath, new LinkOption[0])) {
            throw new IllegalArgumentException("Sidecar Elasticsearch home does not exist: " + this._sidecarHomePath);
        }
        String sidecarLibClassPath = this._createClasspath(this._sidecarHomePath.resolve("lib"), path -> true);
        try {
            return this._processExecutor.execute(this._createProcessConfig(sidecarLibClassPath), (ProcessCallable)new SidecarMainProcessCallable(this._elasticsearchConfigurationWrapper.sidecarHeartbeatInterval(), this._getModifiedClasses(sidecarLibClassPath)));
        }
        catch (ProcessException processException) {
            throw new RuntimeException("Unable to start sidecar Elasticsearch process", processException);
        }
    }

    protected String getBootstrapClassPath() {
        return this._createClasspath(this._processExecutorPaths.getLibPath(), path -> Sidecar.fileNameContains(path, "petra"));
    }

    protected URL getBundleURL() {
        ProtectionDomain protectionDomain = Sidecar.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        return codeSource.getLocation();
    }

    protected String getClusterName() {
        return this._elasticsearchConfigurationWrapper.clusterName();
    }

    protected Path getDataHomePath() {
        return this._dataHomePath;
    }

    protected HashMap<String, String> getEnvironment() {
        return HashMapBuilder.putAll(System.getenv()).put((Object)"HOSTNAME", (Object)"localhost").build();
    }

    protected String getLogProperties() {
        return "";
    }

    protected String getNodeName() {
        String nodeName = this._elasticsearchConfigurationWrapper.nodeName();
        if (!Validator.isBlank((String)nodeName)) {
            return nodeName;
        }
        return "liferay";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected URL getSecurityPolicyURL(URL bundleURL) {
        try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{bundleURL});){
            URL uRL = urlClassLoader.findResource("META-INF/sidecar.policy");
            return uRL;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected Settings getSettings() {
        return ElasticsearchInstanceSettingsBuilder.builder().clusterName(this.getClusterName()).discoveryTypeSingleNode(true).elasticsearchConfigurationWrapper(this._elasticsearchConfigurationWrapper).elasticsearchInstancePaths(this._elasticsearchInstancePaths).httpPortRange(new HttpPortRange(this._elasticsearchConfigurationWrapper)).localBindInetAddressSupplier(() -> ((ClusterExecutor)this._clusterExecutor).getBindInetAddress()).nodeName(this.getNodeName()).settingsContributors(this._settingsContributors).build();
    }

    protected String startElasticsearch(ProcessChannel<Serializable> processChannel) {
        NoticeableFuture noticeableFuture = processChannel.write((ProcessCallable)new StartSidecarProcessCallable(this._getSidecarArguments()));
        try {
            return Sidecar.waitForPublishedAddress((NoticeableFuture<String>)noticeableFuture);
        }
        catch (IOException ioException) {
            if (Objects.equals("Stream closed", ioException.getMessage())) {
                throw new RuntimeException(StringBundler.concat((String[])new String[]{"Sidecar JVM did not launch successfully. ", SidecarMainProcessCallable.class.getSimpleName(), " may have crashed, or its classpath may be missing ", "required libraries"}), ioException);
            }
            processChannel.write((ProcessCallable)new StopSidecarProcessCallable());
            throw new RuntimeException(ioException);
        }
        catch (Exception exception) {
            processChannel.write((ProcessCallable)new StopSidecarProcessCallable());
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _createClasspath(Path dirPath, DirectoryStream.Filter<Path> filter) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath, filter);){
            StringBundler sb = new StringBundler();
            directoryStream.forEach(path -> {
                sb.append(path);
                sb.append(File.pathSeparator);
            });
            if (sb.index() > 0) {
                sb.setIndex(sb.index() - 1);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to iterate " + dirPath, ioException);
        }
    }

    private ProcessConfig _createProcessConfig(String sidecarLibClassPath) {
        ProcessConfig.Builder builder = new ProcessConfig.Builder();
        URL bundleURL = this.getBundleURL();
        return builder.setArguments(this._getJVMArguments(bundleURL)).setBootstrapClassPath(this.getBootstrapClassPath()).setEnvironment(this.getEnvironment()).setProcessLogConsumer(this::consumeProcessLog).setReactClassLoader(Sidecar.class.getClassLoader()).setRuntimeClassPath(StringBundler.concat((String[])new String[]{sidecarLibClassPath, File.pathSeparator, bundleURL.getPath(), File.pathSeparator, this.getBootstrapClassPath()})).build();
    }

    private Distribution _getElasticsearchDistribution() {
        String versionNumber = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/sidecar.version");
        if (versionNumber.equals("7.3.0")) {
            return new Elasticsearch730Distribution();
        }
        if (versionNumber.equals("7.7.0")) {
            return new Elasticsearch770Distribution();
        }
        if (versionNumber.equals("7.9.0")) {
            return new Elasticsearch790Distribution();
        }
        throw new IllegalArgumentException("Unsupported Elasticsearch version: " + versionNumber);
    }

    private List<String> _getJVMArguments(URL bundleURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (String jvmOption : this._elasticsearchConfigurationWrapper.sidecarJVMOptions()) {
            arguments.add(jvmOption);
        }
        if (this._elasticsearchConfigurationWrapper.sidecarDebug()) {
            arguments.add(this._elasticsearchConfigurationWrapper.sidecarDebugSettings());
        }
        try {
            this._sidecarTempDirPath = Files.createTempDirectory("sidecar", new FileAttribute[0]);
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Unable to create temp folder", ioException);
        }
        Path configFolder = this._sidecarTempDirPath.resolve("config");
        try {
            Files.createDirectories(configFolder, new FileAttribute[0]);
            Files.write(configFolder.resolve("log4j2.properties"), Arrays.asList("logger.bootstrapchecks.name=org.elasticsearch.bootstrap.BootstrapChecks", "logger.bootstrapchecks.level=error", "logger.deprecation.name=org.elasticsearch.deprecation", "logger.deprecation.level=error", this.getLogProperties(), ResourceUtil.getResourceAsString(Sidecar.class, "/log4j2.properties")), new OpenOption[0]);
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to copy log4j2.properties to " + configFolder), (Throwable)ioException);
        }
        arguments.add("-Des.path.conf=" + configFolder);
        arguments.add("-Des.networkaddress.cache.ttl=60");
        arguments.add("-Des.networkaddress.cache.negative.ttl=10");
        arguments.add("-Dlog4j.shutdownHookEnabled=false");
        arguments.add("-Dlog4j2.disable.jmx=true");
        arguments.add("-Dio.netty.allocator.type=unpooled");
        arguments.add("-Dio.netty.allocator.numDirectArenas=0");
        arguments.add("-Dio.netty.noUnsafe=true");
        arguments.add("-Dio.netty.noKeySetOptimization=true");
        arguments.add("-Dio.netty.recycler.maxCapacityPerThread=0");
        arguments.add("-Dfile.encoding=UTF-8");
        arguments.add("-Djava.io.tmpdir=" + this._sidecarTempDirPath);
        arguments.add("-Djava.security.policy=" + String.valueOf(this.getSecurityPolicyURL(bundleURL)));
        arguments.add("-Djna.nosys=true");
        return arguments;
    }

    private Map<String, byte[]> _getModifiedClasses(String sidecarLibClassPath) {
        HashMap<String, byte[]> modifiedClasses = new HashMap<String, byte[]>();
        try {
            URLClassLoader classLoader = new URLClassLoader(ClassPathUtil.getClassPathURLs((String)sidecarLibClassPath), null);
            modifiedClasses.put("org.elasticsearch.bootstrap.Natives", ClassModificationUtil.getModifiedClassBytes("org.elasticsearch.bootstrap.Natives", "definitelyRunningAsRoot", methodVisitor -> {
                methodVisitor.visitCode();
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(172);
            }, classLoader));
            modifiedClasses.put("org.elasticsearch.common.settings.KeyStoreWrapper", ClassModificationUtil.getModifiedClassBytes("org.elasticsearch.common.settings.KeyStoreWrapper", "save", methodVisitor -> {
                methodVisitor.visitCode();
                methodVisitor.visitInsn(177);
            }, classLoader));
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to modify classes", (Throwable)exception);
        }
        return modifiedClasses;
    }

    private String[] _getSidecarArguments() {
        Settings settings = this.getSettings();
        StringBundler sb = new StringBundler(2 * settings.size() + 1);
        sb.append("Sidecar Elasticsearch properties : {");
        ArrayList<String> arguments = new ArrayList<String>();
        for (String key : settings.keySet()) {
            arguments.add("-E");
            List list = settings.getAsList(key);
            if (ListUtil.isEmpty((List)list)) continue;
            String keyValue = StringBundler.concat((String[])new String[]{key, "=", StringUtil.merge((Collection)list)});
            arguments.add(keyValue);
            sb.append(keyValue);
            sb.append(",");
        }
        sb.setStringAt("}", sb.index() - 1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)sb.toString());
        }
        return arguments.toArray(new String[0]);
    }

    private void _installElasticsearchIfNeeded() {
        ElasticsearchInstaller.builder().distributablesDirectoryPath(this._elasticsearchInstancePaths.getWorkPath()).distribution(this._getElasticsearchDistribution()).installationDirectoryPath(this._sidecarHomePath).build().install();
    }

    private static class RestartFutureListener
    implements FutureListener<Serializable> {
        private RestartFutureListener() {
        }

        public void complete(Future<Serializable> future) {
            block3: {
                try {
                    future.get();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)"Sidecar Elasticsearch process is aborted", (Throwable)exception);
                }
            }
            SidecarComponentUtil.disableSidecarManager();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Restarting sidecar Elasticsearch process");
            }
            SidecarComponentUtil.enableSidecarManager();
        }
    }
}

