/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.petra.process.ProcessException;
import com.liferay.petra.reflect.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.node.Node;

public class ElasticsearchServerUtil {
    private static final Logger _logger = LogManager.getLogger(ElasticsearchServerUtil.class);
    private static final Field _hooksField;
    private static final Field _instanceField;
    private static final Method _mainMethod;
    private static final Field _nodeField;
    private static final CountDownLatch _shutdownCountDownLatch;
    private static final Method _stopMethod;

    public static void shutdown() {
        try {
            _stopMethod.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            if (_logger.isWarnEnabled()) {
                _logger.warn("Unable to invoke stop method", (Throwable)exception);
            }
            System.exit(70);
        }
        _shutdownCountDownLatch.countDown();
    }

    public static Node start(String[] arguments) throws ProcessException {
        try {
            _mainMethod.invoke(null, new Object[]{arguments});
            System.setSecurityManager(null);
            ElasticsearchServerUtil._addShutdownHook();
            return (Node)_nodeField.get(_instanceField.get(null));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ProcessException("Unable to start elasticsearch server", (Throwable)reflectiveOperationException);
        }
    }

    public static void waitForShutdown() throws ProcessException {
        try {
            _shutdownCountDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new ProcessException("Sidecar main thread is interrupted", (Throwable)interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _addShutdownHook() throws ReflectiveOperationException {
        Class<?> clazz = _hooksField.getDeclaringClass();
        synchronized (clazz) {
            Map hooks = (Map)_hooksField.get(null);
            HashSet threads = new HashSet(hooks.keySet());
            hooks.clear();
            Thread shutdownHook = new Thread(() -> {
                try {
                    _shutdownCountDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (Thread thread : threads) {
                    thread.start();
                }
                block5: for (Thread thread : threads) {
                    while (true) {
                        try {
                            thread.join();
                            continue block5;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }, "Elasticsearch Server Shutdown Hook");
            hooks.put(shutdownHook, shutdownHook);
        }
    }

    static {
        _shutdownCountDownLatch = new CountDownLatch(1);
        try {
            ClassLoader classLoader = ElasticsearchServerUtil.class.getClassLoader();
            _hooksField = ReflectionUtil.getDeclaredField(classLoader.loadClass("java.lang.ApplicationShutdownHooks"), (String)"hooks");
            _mainMethod = ReflectionUtil.getDeclaredMethod(classLoader.loadClass("org.elasticsearch.bootstrap.Elasticsearch"), (String)"main", (Class[])new Class[]{String[].class});
            Class<?> bootstrapClass = classLoader.loadClass("org.elasticsearch.bootstrap.Bootstrap");
            _instanceField = ReflectionUtil.getDeclaredField(bootstrapClass, (String)"INSTANCE");
            _nodeField = ReflectionUtil.getDeclaredField(bootstrapClass, (String)"node");
            _stopMethod = ReflectionUtil.getDeclaredMethod(bootstrapClass, (String)"stop", (Class[])new Class[0]);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

