/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Distributable;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Distribution;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.PathUtil;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.UncompressUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class ElasticsearchInstaller {
    private static final Path _temporaryDirectoryPath = ElasticsearchInstaller.getTemporaryDirectoryPath();
    private Path _distributablesDirectoryPath;
    private Distribution _distribution;
    private Path _installationDirectoryPath;

    public static Builder builder() {
        return new Builder();
    }

    public ElasticsearchInstaller() {
    }

    public ElasticsearchInstaller(ElasticsearchInstaller elasticsearchInstaller) {
        this._distributablesDirectoryPath = elasticsearchInstaller._distributablesDirectoryPath;
        this._distribution = elasticsearchInstaller._distribution;
        this._installationDirectoryPath = elasticsearchInstaller._installationDirectoryPath;
    }

    public void install() {
        if (this.isAlreadyInstalled()) {
            return;
        }
        this.createDestinationDirectory();
        try {
            this.createTemporaryDownloadDirectory();
            try {
                this.downloadAndInstallElasticsearch();
                this.downloadAndInstallPlugins();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                this.deleteTemporaryDownloadDirectory();
            }
        }
        catch (RuntimeException runtimeException) {
            this.deleteDestinationDirectory();
            throw runtimeException;
        }
    }

    protected static String getChecksum(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            String string = DigestUtils.sha512Hex((InputStream)inputStream);
            return string;
        }
    }

    protected static Path getExtractedElasticsearchDirectoryPath(Path extractedRootDirectoryPath) throws IOException {
        try (Stream<Path> stream = Files.list(extractedRootDirectoryPath);){
            Path path = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findAny().get();
            return path;
        }
    }

    protected static Path getTemporaryDirectoryPath() {
        Path path = Paths.get(SystemProperties.get((String)"java.io.tmpdir"), new String[0]);
        return path.resolve(ElasticsearchInstaller.class.getSimpleName());
    }

    protected static void guardChecksum(Path filePath, String checksum) throws IOException {
        if (!checksum.equals(ElasticsearchInstaller.getChecksum(filePath))) {
            throw new RuntimeException("Checksum mismatch");
        }
    }

    protected void createDestinationDirectory() {
        this.createDirectories(this._installationDirectoryPath);
    }

    protected void createDirectories(Path directoryPath) {
        try {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected void createTemporaryDownloadDirectory() {
        this.createDirectories(_temporaryDirectoryPath);
    }

    protected void deleteDestinationDirectory() {
        PathUtil.deleteDir(this._installationDirectoryPath);
    }

    protected void deleteTemporaryDownloadDirectory() {
        PathUtil.deleteDir(_temporaryDirectoryPath);
    }

    protected void downloadAndInstallElasticsearch() throws IOException {
        Path filePath = this.getFilePath(this._distribution.getElasticsearchDistributable());
        UncompressUtil.unarchive(filePath, _temporaryDirectoryPath);
        Path extractedElasticsearchDirectoryPath = ElasticsearchInstaller.getExtractedElasticsearchDirectoryPath(_temporaryDirectoryPath);
        PathUtil.copyDirectory(extractedElasticsearchDirectoryPath.resolve("lib"), this._installationDirectoryPath.resolve("lib"), new Path[0]);
        Path extractedModulesDirectoryPath = extractedElasticsearchDirectoryPath.resolve("modules");
        PathUtil.copyDirectory(extractedModulesDirectoryPath, this._installationDirectoryPath.resolve("modules"), extractedModulesDirectoryPath.resolve("ingest-geoip"));
    }

    protected void downloadAndInstallPlugin(Distributable distributable) throws IOException {
        Path filePath = this.getFilePath(distributable);
        String pluginName = StringUtils.substringBeforeLast((String)String.valueOf(filePath.getFileName()), (String)"-");
        Path extractedDirectoryPath = _temporaryDirectoryPath.resolve(pluginName);
        UncompressUtil.unzip(filePath, extractedDirectoryPath);
        Path pluginsDirectoryPath = this._installationDirectoryPath.resolve("plugins");
        this.createDirectories(pluginsDirectoryPath);
        Path pluginDestinationDirectoryPath = pluginsDirectoryPath.resolve(pluginName);
        PathUtil.copyDirectory(extractedDirectoryPath, pluginDestinationDirectoryPath, new Path[0]);
    }

    protected void downloadAndInstallPlugins() throws IOException {
        for (Distributable distributable : this._distribution.getPluginDistributables()) {
            this.downloadAndInstallPlugin(distributable);
        }
    }

    protected Path getFilePath(Distributable distributable) throws IOException {
        Path filePath = this.locateOrDownload(distributable);
        ElasticsearchInstaller.guardChecksum(filePath, distributable.getChecksum());
        return filePath;
    }

    protected boolean isAlreadyInstalled() {
        return Files.exists(this._installationDirectoryPath, new LinkOption[0]);
    }

    protected Path locateOrDownload(Distributable distributable) throws IOException {
        String downloadURLString = distributable.getDownloadURLString();
        String fileName = StringUtils.substringAfterLast((String)downloadURLString, (String)"/");
        Path distributableFilePath = this._distributablesDirectoryPath.resolve(fileName);
        if (Files.exists(distributableFilePath, new LinkOption[0])) {
            return distributableFilePath;
        }
        Path downloadedFilePath = _temporaryDirectoryPath.resolve(fileName);
        PathUtil.download(new URL(downloadURLString), downloadedFilePath);
        return downloadedFilePath;
    }

    public static class Builder {
        private final ElasticsearchInstaller _elasticsearchInstaller = new ElasticsearchInstaller();

        public ElasticsearchInstaller build() {
            return new ElasticsearchInstaller(this._elasticsearchInstaller);
        }

        public Builder distributablesDirectoryPath(Path distributablesDirectoryPath) {
            this._elasticsearchInstaller._distributablesDirectoryPath = distributablesDirectoryPath;
            return this;
        }

        public Builder distribution(Distribution distribution) {
            this._elasticsearchInstaller._distribution = distribution;
            return this;
        }

        public Builder installationDirectoryPath(Path installationDirectoryPath) {
            this._elasticsearchInstaller._installationDirectoryPath = installationDirectoryPath;
            return this;
        }
    }
}

