/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.response;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.SearchHitDocumentTranslator;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetCollectorFactory;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetUtil;
import com.liferay.portal.search.elasticsearch7.internal.search.response.HitsImpl;
import com.liferay.portal.search.elasticsearch7.internal.search.response.SearchResponseTranslator;
import com.liferay.portal.search.elasticsearch7.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.groupby.GroupByResponse;
import com.liferay.portal.search.groupby.GroupByResponseFactory;
import com.liferay.portal.search.legacy.stats.StatsRequestBuilderFactory;
import com.liferay.portal.search.legacy.stats.StatsResultsTranslator;
import com.liferay.portal.search.stats.StatsRequest;
import com.liferay.portal.search.stats.StatsRequestBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchResponseTranslator.class})
public class DefaultSearchResponseTranslator
implements SearchResponseTranslator {
    private GroupByResponseFactory _groupByResponseFactory;
    private SearchHitDocumentTranslator _searchHitDocumentTranslator;
    private StatsRequestBuilderFactory _statsRequestBuilderFactory;
    private StatsResultsTranslator _statsResultsTranslator;
    private StatsTranslator _statsTranslator;

    @Override
    public void populate(SearchSearchResponse searchSearchResponse, SearchResponse searchResponse, SearchSearchRequest searchSearchRequest) {
        SearchHits searchHits = searchResponse.getHits();
        HitsImpl hits = new HitsImpl();
        this.updateFacetCollectors(searchResponse, searchSearchRequest.getFacets());
        this.updateGroupedHits(searchSearchResponse, searchResponse, searchSearchRequest, (Hits)hits, searchSearchRequest.getAlternateUidFieldName(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.getLocale());
        this.updateStatsResults((Hits)hits, searchResponse.getAggregations(), (Map<String, Stats>)searchSearchRequest.getStats());
        TimeValue timeValue = searchResponse.getTook();
        hits.setSearchTime((float)timeValue.getSecondsFrac());
        this.processSearchHits(searchHits, hits, searchSearchRequest.getAlternateUidFieldName(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.getLocale());
        searchSearchResponse.setHits((Hits)hits);
    }

    protected void addSnippets(Document document, Map<String, HighlightField> highlightFields, String fieldName, Locale locale) {
        String snippetFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        HighlightField highlightField = highlightFields.get(snippetFieldName);
        if (highlightField == null) {
            highlightField = highlightFields.get(fieldName);
            snippetFieldName = fieldName;
        }
        if (highlightField == null) {
            return;
        }
        Object[] array = highlightField.fragments();
        document.addText(StringBundler.concat((String[])new String[]{"snippet", "_", snippetFieldName}), StringUtil.merge((Object[])array, (String)"..."));
    }

    protected void addSnippets(SearchHit hit, Document document, String[] highlightFieldNames, Locale locale) {
        Map highlightFields = hit.getHighlightFields();
        if (MapUtil.isEmpty((Map)highlightFields)) {
            return;
        }
        highlightFields.forEach((fieldName, highlightField) -> this.addSnippets(document, highlightFields, (String)fieldName, locale));
    }

    protected FacetCollector getFacetCollector(Facet facet, Map<String, Aggregation> aggregationsMap) {
        FacetCollectorFactory facetCollectorFactory = new FacetCollectorFactory();
        return facetCollectorFactory.getFacetCollector(aggregationsMap.get(FacetUtil.getAggregationName(facet)));
    }

    protected StatsResults getStatsResults(Map<String, Aggregation> aggregationsMap, Stats stats) {
        return this._statsResultsTranslator.translate(this._statsTranslator.translateResponse(aggregationsMap, this.translate(stats)));
    }

    protected void populateUID(Document document, String alternateUidFieldName) {
        Field uidField = document.getField("uid");
        if (uidField != null) {
            return;
        }
        if (Validator.isNull((String)alternateUidFieldName)) {
            return;
        }
        String uidValue = document.get(alternateUidFieldName);
        if (Validator.isNotNull((String)uidValue)) {
            uidField = new Field("uid", uidValue);
            document.add(uidField);
        }
    }

    protected Document processSearchHit(SearchHit searchHit, String alternateUidFieldName) {
        Document document = this._searchHitDocumentTranslator.translate(searchHit);
        this.populateUID(document, alternateUidFieldName);
        return document;
    }

    protected Hits processSearchHits(SearchHits searchHits, Hits hits, String alternateUidFieldName, String[] highlightFieldNames, Locale locale) {
        ArrayList<Document> documents = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        TotalHits totalHits = searchHits.getTotalHits();
        if (totalHits.value > 0L) {
            SearchHit[] searchHitsArray;
            for (SearchHit searchHit : searchHitsArray = searchHits.getHits()) {
                Document document = this.processSearchHit(searchHit, alternateUidFieldName);
                documents.add(document);
                scores.add(Float.valueOf(searchHit.getScore()));
                this.addSnippets(searchHit, document, highlightFieldNames, locale);
            }
        }
        hits.setDocs(documents.toArray(new Document[0]));
        hits.setLength((int)totalHits.value);
        hits.setQueryTerms(new String[0]);
        hits.setScores(ArrayUtil.toFloatArray(scores));
        return hits;
    }

    @Reference(unbind="-")
    protected void setGroupByResponseFactory(GroupByResponseFactory groupByResponseFactory) {
        this._groupByResponseFactory = groupByResponseFactory;
    }

    @Reference(unbind="-")
    protected void setSearchHitDocumentTranslator(SearchHitDocumentTranslator searchHitDocumentTranslator) {
        this._searchHitDocumentTranslator = searchHitDocumentTranslator;
    }

    @Reference(unbind="-")
    protected void setStatsRequestBuilderFactory(StatsRequestBuilderFactory statsRequestBuilderFactory) {
        this._statsRequestBuilderFactory = statsRequestBuilderFactory;
    }

    @Reference(unbind="-")
    protected void setStatsResultsTranslator(StatsResultsTranslator statsResultsTranslator) {
        this._statsResultsTranslator = statsResultsTranslator;
    }

    @Reference(unbind="-")
    protected void setStatsTranslator(StatsTranslator statsTranslator) {
        this._statsTranslator = statsTranslator;
    }

    protected StatsRequest translate(Stats stats) {
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder(stats);
        return statsRequestBuilder.build();
    }

    protected void updateFacetCollectors(SearchResponse searchResponse, Map<String, Facet> facetsMap) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return;
        }
        Map aggregationsMap = aggregations.getAsMap();
        for (Facet facet : facetsMap.values()) {
            if (facet.isStatic()) continue;
            facet.setFacetCollector(this.getFacetCollector(facet, aggregationsMap));
        }
    }

    protected void updateGroupedHits(SearchSearchResponse searchSearchResponse, SearchResponse searchResponse, SearchSearchRequest searchSearchRequest, Hits hits, String alternateUidFieldName, String[] highlightFieldNames, Locale locale) {
        GroupBy groupBy;
        List groupByRequests = searchSearchRequest.getGroupByRequests();
        if (ListUtil.isNotEmpty((List)groupByRequests)) {
            for (GroupByRequest groupByRequest : groupByRequests) {
                this.updateGroupedHits(searchSearchResponse, searchResponse, groupByRequest.getField(), hits, alternateUidFieldName, highlightFieldNames, locale);
            }
        }
        if ((groupBy = searchSearchRequest.getGroupBy()) != null) {
            this.updateGroupedHits(searchSearchResponse, searchResponse, groupBy.getField(), hits, alternateUidFieldName, highlightFieldNames, locale);
        }
    }

    protected void updateGroupedHits(SearchSearchResponse searchSearchResponse, SearchResponse searchResponse, String field, Hits hits, String alternateUidFieldName, String[] highlightFieldNames, Locale locale) {
        Aggregations aggregations = searchResponse.getAggregations();
        Map aggregationsMap = aggregations.getAsMap();
        Terms terms = (Terms)aggregationsMap.get("GroupBy_" + field);
        List buckets = terms.getBuckets();
        GroupByResponse groupByResponse = this._groupByResponseFactory.getGroupByResponse(field);
        searchSearchResponse.addGroupByResponse(groupByResponse);
        for (Terms.Bucket bucket : buckets) {
            Aggregations bucketAggregations = bucket.getAggregations();
            TopHits topHits = (TopHits)bucketAggregations.get("_topHits");
            SearchHits groupedSearchHits = topHits.getHits();
            HitsImpl groupedHits = new HitsImpl();
            this.processSearchHits(groupedSearchHits, groupedHits, alternateUidFieldName, highlightFieldNames, locale);
            TotalHits totalHits = groupedSearchHits.getTotalHits();
            groupedHits.setLength((int)totalHits.value);
            hits.addGroupedHits(bucket.getKeyAsString(), (Hits)groupedHits);
            groupByResponse.putHits(bucket.getKeyAsString(), (Hits)groupedHits);
        }
    }

    protected void updateStatsResults(Hits hits, Aggregations aggregations, Map<String, Stats> statsMap) {
        if (aggregations != null) {
            this.updateStatsResults(hits, aggregations.getAsMap(), statsMap);
        }
    }

    protected void updateStatsResults(Hits hits, Map<String, Aggregation> aggregationsMap, Map<String, Stats> statsMap) {
        if (!MapUtil.isEmpty(statsMap)) {
            for (Stats stats : statsMap.values()) {
                hits.addStatsResults(this.getStatsResults(aggregationsMap, stats));
            }
        }
    }
}

