/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.GetSnapshotsRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.SnapshotInfoConverter;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotsResponse;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotDetails;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SnapshotClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetSnapshotsRequestExecutor.class})
public class GetSnapshotsRequestExecutorImpl
implements GetSnapshotsRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public GetSnapshotsResponse execute(com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotsRequest getSnapshotsRequest) {
        GetSnapshotsRequest elasticsearchGetSnapshotsRequest = this.createGetSnapshotsRequest(getSnapshotsRequest);
        org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse elasticsearchGetSnapshotsResponse = this.getGetSnapshotsResponse(elasticsearchGetSnapshotsRequest, getSnapshotsRequest);
        GetSnapshotsResponse getSnapshotsResponse = new GetSnapshotsResponse();
        List snapshotInfos = elasticsearchGetSnapshotsResponse.getSnapshots();
        snapshotInfos.forEach(snapshotInfo -> {
            SnapshotDetails snapshotDetails = SnapshotInfoConverter.convert(snapshotInfo);
            getSnapshotsResponse.addSnapshotInfo(snapshotDetails);
        });
        return getSnapshotsResponse;
    }

    protected GetSnapshotsRequest createGetSnapshotsRequest(com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotsRequest getSnapshotsRequest) {
        GetSnapshotsRequest elasticsearchGetSnapshotsRequest = new GetSnapshotsRequest();
        elasticsearchGetSnapshotsRequest.ignoreUnavailable(getSnapshotsRequest.isIgnoreUnavailable());
        elasticsearchGetSnapshotsRequest.repository(getSnapshotsRequest.getRepositoryName());
        elasticsearchGetSnapshotsRequest.snapshots(getSnapshotsRequest.getSnapshotNames());
        elasticsearchGetSnapshotsRequest.verbose(getSnapshotsRequest.isVerbose());
        return elasticsearchGetSnapshotsRequest;
    }

    protected org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse getGetSnapshotsResponse(GetSnapshotsRequest elasticsearchGetSnapshotsRequest, com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotsRequest getSnapshotsRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(getSnapshotsRequest.getConnectionId(), getSnapshotsRequest.isPreferLocalCluster());
        SnapshotClient snapshotClient = restHighLevelClient.snapshot();
        try {
            return snapshotClient.get(elasticsearchGetSnapshotsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

