/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.DeleteSnapshotRequestExecutor;
import com.liferay.portal.search.engine.adapter.snapshot.DeleteSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.DeleteSnapshotResponse;
import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SnapshotClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DeleteSnapshotRequestExecutor.class})
public class DeleteSnapshotRequestExecutorImpl
implements DeleteSnapshotRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public DeleteSnapshotResponse execute(DeleteSnapshotRequest deleteSnapshotRequest) {
        org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest elasticsearchDeleteSnapshotRequest = this.createDeleteSnapshotRequest(deleteSnapshotRequest);
        AcknowledgedResponse acknowledgedResponse = this.getAcknowledgedResponse(elasticsearchDeleteSnapshotRequest, deleteSnapshotRequest);
        return new DeleteSnapshotResponse(acknowledgedResponse.isAcknowledged());
    }

    protected org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest createDeleteSnapshotRequest(DeleteSnapshotRequest deleteSnapshotRequest) {
        org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest elasticsearchDeleteSnapshotRequest = new org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest();
        elasticsearchDeleteSnapshotRequest.repository(deleteSnapshotRequest.getRepositoryName());
        elasticsearchDeleteSnapshotRequest.snapshots(new String[]{deleteSnapshotRequest.getSnapshotName()});
        return elasticsearchDeleteSnapshotRequest;
    }

    protected AcknowledgedResponse getAcknowledgedResponse(org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest elasticsearchDeleteSnapshotRequest, DeleteSnapshotRequest deleteSnapshotRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(deleteSnapshotRequest.getConnectionId(), deleteSnapshotRequest.isPreferLocalCluster());
        SnapshotClient snapshotClient = restHighLevelClient.snapshot();
        try {
            return snapshotClient.delete(elasticsearchDeleteSnapshotRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

