/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.CreateSnapshotRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.SnapshotInfoConverter;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotResponse;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotDetails;
import java.io.IOException;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SnapshotClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CreateSnapshotRequestExecutor.class})
public class CreateSnapshotRequestExecutorImpl
implements CreateSnapshotRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public CreateSnapshotResponse execute(CreateSnapshotRequest createSnapshotRequest) {
        org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest elasticsearchCreateSnapshotRequest = this.createCreateSnapshotRequest(createSnapshotRequest);
        org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse elasticsearchCreateSnapshotResponse = this.getCreateSnapshotResponse(elasticsearchCreateSnapshotRequest, createSnapshotRequest);
        SnapshotDetails snapshotDetails = SnapshotInfoConverter.convert(elasticsearchCreateSnapshotResponse.getSnapshotInfo());
        return new CreateSnapshotResponse(snapshotDetails);
    }

    protected org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest createCreateSnapshotRequest(CreateSnapshotRequest createSnapshotRequest) {
        org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest elasticsearchCreateSnapshotRequest = new org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest();
        if (ArrayUtil.isNotEmpty((Object[])createSnapshotRequest.getIndexNames())) {
            elasticsearchCreateSnapshotRequest.indices(createSnapshotRequest.getIndexNames());
        }
        elasticsearchCreateSnapshotRequest.repository(createSnapshotRequest.getRepositoryName());
        elasticsearchCreateSnapshotRequest.snapshot(createSnapshotRequest.getSnapshotName());
        elasticsearchCreateSnapshotRequest.waitForCompletion(createSnapshotRequest.isWaitForCompletion());
        return elasticsearchCreateSnapshotRequest;
    }

    protected org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse getCreateSnapshotResponse(org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest elasticsearchCreateSnapshotRequest, CreateSnapshotRequest createSnapshotRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(createSnapshotRequest.getConnectionId(), createSnapshotRequest.isPreferLocalCluster());
        SnapshotClient snapshotClient = restHighLevelClient.snapshot();
        try {
            return snapshotClient.create(elasticsearchCreateSnapshotRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

