/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.CreateSnapshotRepositoryRequestExecutor;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRepositoryRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRepositoryResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SnapshotClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.fs.FsRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CreateSnapshotRepositoryRequestExecutor.class})
public class CreateSnapshotRepositoryRequestExecutorImpl
implements CreateSnapshotRepositoryRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public CreateSnapshotRepositoryResponse execute(CreateSnapshotRepositoryRequest createSnapshotRepositoryRequest) {
        PutRepositoryRequest putRepositoryRequest = this.createPutRepositoryRequest(createSnapshotRepositoryRequest);
        AcknowledgedResponse acknowledgedResponse = this.getAcknowledgedResponse(putRepositoryRequest, createSnapshotRepositoryRequest);
        return new CreateSnapshotRepositoryResponse(acknowledgedResponse.isAcknowledged());
    }

    protected PutRepositoryRequest createPutRepositoryRequest(CreateSnapshotRepositoryRequest createSnapshotRepositoryRequest) {
        PutRepositoryRequest putRepositoryRequest = new PutRepositoryRequest(createSnapshotRepositoryRequest.getName());
        Settings.Builder builder = Settings.builder();
        builder.put(FsRepository.COMPRESS_SETTING.getKey(), createSnapshotRepositoryRequest.isCompress());
        builder.put(FsRepository.LOCATION_SETTING.getKey(), createSnapshotRepositoryRequest.getLocation());
        putRepositoryRequest.settings(builder);
        putRepositoryRequest.type(createSnapshotRepositoryRequest.getType());
        putRepositoryRequest.verify(createSnapshotRepositoryRequest.isVerify());
        return putRepositoryRequest;
    }

    protected AcknowledgedResponse getAcknowledgedResponse(PutRepositoryRequest putRepositoryRequest, CreateSnapshotRepositoryRequest createSnapshotRepositoryRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(createSnapshotRepositoryRequest.getConnectionId(), createSnapshotRepositoryRequest.isPreferLocalCluster());
        SnapshotClient snapshotClient = restHighLevelClient.snapshot();
        try {
            return snapshotClient.createRepository(putRepositoryRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

