/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.AggregationResultTranslator;
import com.liferay.portal.search.aggregation.AggregationResults;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationResultTranslator;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.AggregationResultTranslatorFactory;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.ElasticsearchAggregationResultTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.ElasticsearchAggregationResultsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.PipelineAggregationResultTranslatorFactory;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.pipeline.ElasticsearchPipelineAggregationResultTranslator;
import com.liferay.portal.search.elasticsearch7.internal.hits.SearchHitsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.response.SearchResponseTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.highlight.HighlightFieldBuilderFactory;
import com.liferay.portal.search.hits.SearchHitBuilderFactory;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.hits.SearchHitsBuilderFactory;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSearchResponseAssembler.class})
public class SearchSearchResponseAssemblerImpl
implements AggregationResultTranslatorFactory,
PipelineAggregationResultTranslatorFactory,
SearchSearchResponseAssembler {
    private AggregationResults _aggregationResults;
    private CommonSearchResponseAssembler _commonSearchResponseAssembler;
    private DocumentBuilderFactory _documentBuilderFactory;
    private GeoBuilders _geoBuilders;
    private HighlightFieldBuilderFactory _highlightFieldBuilderFactory;
    private SearchHitBuilderFactory _searchHitBuilderFactory;
    private SearchHitsBuilderFactory _searchHitsBuilderFactory;
    private SearchResponseTranslator _searchResponseTranslator;

    @Override
    public void assemble(SearchSourceBuilder searchRequestBuilder, SearchResponse searchResponse, SearchSearchRequest searchSearchRequest, SearchSearchResponse searchSearchResponse) {
        this._commonSearchResponseAssembler.assemble(searchRequestBuilder, searchResponse, (BaseSearchRequest)searchSearchRequest, (BaseSearchResponse)searchSearchResponse);
        this.addAggregations(searchResponse, searchSearchResponse, searchSearchRequest);
        this.setCount(searchResponse, searchSearchResponse);
        this.setScrollId(searchResponse, searchSearchResponse);
        this.setSearchHits(searchResponse, searchSearchResponse, searchSearchRequest);
        this._searchResponseTranslator.populate(searchSearchResponse, searchResponse, searchSearchRequest);
    }

    @Override
    public AggregationResultTranslator createAggregationResultTranslator(Aggregation elasticsearchAggregation) {
        return new ElasticsearchAggregationResultTranslator(elasticsearchAggregation, this._aggregationResults, new SearchHitsTranslator(this._searchHitBuilderFactory, this._searchHitsBuilderFactory, this._documentBuilderFactory, this._highlightFieldBuilderFactory, this._geoBuilders), this._geoBuilders);
    }

    @Override
    public PipelineAggregationResultTranslator createPipelineAggregationResultTranslator(Aggregation elasticsearchAggregation) {
        return new ElasticsearchPipelineAggregationResultTranslator(elasticsearchAggregation, this._aggregationResults);
    }

    protected void addAggregations(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse, SearchSearchRequest searchSearchRequest) {
        Aggregations elasticsearchAggregations = searchResponse.getAggregations();
        if (elasticsearchAggregations == null) {
            return;
        }
        Map aggregationsMap = searchSearchRequest.getAggregationsMap();
        Map pipelineAggregationsMap = searchSearchRequest.getPipelineAggregationsMap();
        ElasticsearchAggregationResultsTranslator elasticsearchAggregationResultsTranslator = new ElasticsearchAggregationResultsTranslator(this, this, aggregationsMap::get, pipelineAggregationsMap::get);
        Stream<AggregationResult> stream = elasticsearchAggregationResultsTranslator.translate(elasticsearchAggregations);
        stream.forEach(arg_0 -> ((SearchSearchResponse)searchSearchResponse).addAggregationResult(arg_0));
    }

    @Reference(unbind="-")
    protected void setAggregationResults(AggregationResults aggregationResults) {
        this._aggregationResults = aggregationResults;
    }

    @Reference(unbind="-")
    protected void setCommonSearchResponseAssembler(CommonSearchResponseAssembler commonSearchResponseAssembler) {
        this._commonSearchResponseAssembler = commonSearchResponseAssembler;
    }

    protected void setCount(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse) {
        org.elasticsearch.search.SearchHits searchHits = searchResponse.getHits();
        TotalHits totalHits = searchHits.getTotalHits();
        searchSearchResponse.setCount(totalHits.value);
    }

    @Reference(unbind="-")
    protected void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this._documentBuilderFactory = documentBuilderFactory;
    }

    @Reference(unbind="-")
    protected void setGeoBuilders(GeoBuilders geoBuilders) {
        this._geoBuilders = geoBuilders;
    }

    @Reference(unbind="-")
    protected void setHighlightFieldBuilderFactory(HighlightFieldBuilderFactory highlightFieldBuilderFactory) {
        this._highlightFieldBuilderFactory = highlightFieldBuilderFactory;
    }

    protected void setScrollId(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse) {
        if (Validator.isNotNull((String)searchResponse.getScrollId())) {
            searchSearchResponse.setScrollId(searchResponse.getScrollId());
        }
    }

    @Reference(unbind="-")
    protected void setSearchHitBuilderFactory(SearchHitBuilderFactory searchHitBuilderFactory) {
        this._searchHitBuilderFactory = searchHitBuilderFactory;
    }

    protected void setSearchHits(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse, SearchSearchRequest searchSearchRequest) {
        SearchHitsTranslator searchHitsTranslator = new SearchHitsTranslator(this._searchHitBuilderFactory, this._searchHitsBuilderFactory, this._documentBuilderFactory, this._highlightFieldBuilderFactory, this._geoBuilders);
        org.elasticsearch.search.SearchHits elasticsearchSearchHits = searchResponse.getHits();
        SearchHits searchHits = searchHitsTranslator.translate(searchSearchRequest, elasticsearchSearchHits, searchSearchRequest.getAlternateUidFieldName());
        searchSearchResponse.setSearchHits(searchHits);
    }

    @Reference(unbind="-")
    protected void setSearchHitsBuilderFactory(SearchHitsBuilderFactory searchHitsBuilderFactory) {
        this._searchHitsBuilderFactory = searchHitsBuilderFactory;
    }

    @Reference(unbind="-")
    protected void setSearchResponseTranslator(SearchResponseTranslator searchResponseTranslator) {
        this._searchResponseTranslator = searchResponseTranslator;
    }
}

