/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.groupby.GroupByTranslator;
import com.liferay.portal.search.elasticsearch7.internal.highlight.HighlightTranslator;
import com.liferay.portal.search.elasticsearch7.internal.highlight.HighlighterTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.QueryToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchSourceBuilderAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch7.internal.sort.SortTranslator;
import com.liferay.portal.search.elasticsearch7.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.legacy.groupby.GroupByRequestFactory;
import com.liferay.portal.search.legacy.stats.StatsRequestBuilderFactory;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldTranslator;
import com.liferay.portal.search.stats.StatsRequest;
import com.liferay.portal.search.stats.StatsRequestBuilder;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSearchRequestAssembler.class})
public class SearchSearchRequestAssemblerImpl
implements SearchSearchRequestAssembler {
    private CommonSearchSourceBuilderAssembler _commonSearchSourceBuilderAssembler;
    private GroupByRequestFactory _groupByRequestFactory;
    private GroupByTranslator _groupByTranslator;
    private HighlighterTranslator _highlighterTranslator;
    private final HighlightTranslator _highlightTranslator = new HighlightTranslator();
    private QueryToQueryBuilderTranslator _queryToQueryBuilderTranslator;
    private SortFieldTranslator<SortBuilder<?>> _sortFieldTranslator;
    private SortTranslator _sortTranslator;
    private StatsRequestBuilderFactory _statsRequestBuilderFactory;
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest, SearchRequest searchRequest) {
        this._commonSearchSourceBuilderAssembler.assemble(searchSourceBuilder, (BaseSearchRequest)searchSearchRequest, searchRequest);
        this.setFetchSource(searchSourceBuilder, searchSearchRequest);
        this.setGroupBy(searchSourceBuilder, searchSearchRequest);
        this.setGroupByRequests(searchSourceBuilder, searchSearchRequest);
        this.setHighlighter(searchSourceBuilder, searchSearchRequest);
        this.setPagination(searchSourceBuilder, searchSearchRequest);
        this.setPreference(searchRequest, searchSearchRequest);
        this.setSorts(searchSourceBuilder, searchSearchRequest);
        this.setStats(searchSourceBuilder, searchSearchRequest);
        this.setStoredFields(searchSourceBuilder, searchSearchRequest);
        this.setTrackScores(searchSourceBuilder, searchSearchRequest);
        this.setVersion(searchSourceBuilder, searchSearchRequest);
        searchRequest.source(searchSourceBuilder);
    }

    @Reference(unbind="-")
    protected void setCommonSearchSourceBuilderAssembler(CommonSearchSourceBuilderAssembler commonSearchSourceBuilderAssembler) {
        this._commonSearchSourceBuilderAssembler = commonSearchSourceBuilderAssembler;
    }

    protected void setFetchSource(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getFetchSource() != null || searchSearchRequest.getFetchSourceExcludes() != null || searchSearchRequest.getFetchSourceIncludes() != null) {
            if (searchSearchRequest.getFetchSource() == null) {
                searchSourceBuilder.fetchSource(true);
            } else {
                searchSourceBuilder.fetchSource(searchSearchRequest.getFetchSource().booleanValue());
            }
            searchSourceBuilder.fetchSource(searchSearchRequest.getFetchSourceIncludes(), searchSearchRequest.getFetchSourceExcludes());
        }
    }

    protected void setGroupBy(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getGroupBy() != null) {
            this._groupByTranslator.translate(searchSourceBuilder, this.translate(searchSearchRequest.getGroupBy()), searchSearchRequest.getLocale(), searchSearchRequest.getSelectedFieldNames(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize());
        }
    }

    @Reference(unbind="-")
    protected void setGroupByRequestFactory(GroupByRequestFactory groupByRequestFactory) {
        this._groupByRequestFactory = groupByRequestFactory;
    }

    protected void setGroupByRequests(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        List groupByRequests = searchSearchRequest.getGroupByRequests();
        if (ListUtil.isNotEmpty((List)groupByRequests)) {
            groupByRequests.forEach(groupByRequest -> this._groupByTranslator.translate(searchSourceBuilder, (GroupByRequest)groupByRequest, searchSearchRequest.getLocale(), searchSearchRequest.getSelectedFieldNames(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize()));
        }
    }

    @Reference(unbind="-")
    protected void setGroupByTranslator(GroupByTranslator groupByTranslator) {
        this._groupByTranslator = groupByTranslator;
    }

    protected void setHighlighter(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getHighlight() != null) {
            searchSourceBuilder.highlighter(this._highlightTranslator.translate(searchSearchRequest.getHighlight(), this._queryToQueryBuilderTranslator));
        } else if (searchSearchRequest.isHighlightEnabled()) {
            this._highlighterTranslator.translate(searchSourceBuilder, searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize(), searchSearchRequest.isLuceneSyntax());
        }
    }

    @Reference(unbind="-")
    protected void setHighlighterTranslator(HighlighterTranslator highlighterTranslator) {
        this._highlighterTranslator = highlighterTranslator;
    }

    protected void setPagination(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getStart() != null) {
            searchSourceBuilder.from(searchSearchRequest.getStart().intValue());
        }
        if (searchSearchRequest.getSize() != null) {
            searchSourceBuilder.size(searchSearchRequest.getSize().intValue());
        }
    }

    protected void setPreference(SearchRequest searchRequest, SearchSearchRequest searchSearchRequest) {
        String preference = searchSearchRequest.getPreference();
        if (!Validator.isBlank((String)preference)) {
            searchRequest.preference(preference);
        }
    }

    @Reference(unbind="-")
    protected void setQueryToQueryBuilderTranslator(QueryToQueryBuilderTranslator queryToQueryBuilderTranslator) {
        this._queryToQueryBuilderTranslator = queryToQueryBuilderTranslator;
    }

    @Reference(unbind="-")
    protected void setSortFieldTranslator(SortFieldTranslator<SortBuilder<?>> sortFieldTranslator) {
        this._sortFieldTranslator = sortFieldTranslator;
    }

    protected void setSorts(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        for (Sort sort : searchSearchRequest.getSorts()) {
            searchSourceBuilder.sort((SortBuilder)this._sortFieldTranslator.translate(sort));
        }
        this._sortTranslator.translate(searchSourceBuilder, searchSearchRequest.getSorts71());
    }

    @Reference(unbind="-")
    protected void setSortTranslator(SortTranslator sortTranslator) {
        this._sortTranslator = sortTranslator;
    }

    protected void setStats(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        Map statsMap = searchSearchRequest.getStats();
        if (!MapUtil.isEmpty((Map)statsMap)) {
            statsMap.forEach((key, stats) -> this._statsTranslator.populateRequest(searchSourceBuilder, this.translate((Stats)stats)));
        }
    }

    @Reference(unbind="-")
    protected void setStatsRequestBuilderFactory(StatsRequestBuilderFactory statsRequestBuilderFactory) {
        this._statsRequestBuilderFactory = statsRequestBuilderFactory;
    }

    @Reference(unbind="-")
    protected void setStatsTranslator(StatsTranslator statsTranslator) {
        this._statsTranslator = statsTranslator;
    }

    protected void setStoredFields(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        Object[] selectedFieldNames = searchSearchRequest.getSelectedFieldNames();
        if (!ArrayUtil.isEmpty((Object[])selectedFieldNames)) {
            searchSourceBuilder.storedFields(ListUtil.fromArray((Object[])selectedFieldNames));
        } else {
            searchSourceBuilder.storedField("*");
        }
    }

    protected void setTrackScores(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getScoreEnabled() != null) {
            searchSourceBuilder.trackScores(searchSearchRequest.getScoreEnabled().booleanValue());
        }
    }

    protected void setVersion(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getVersion() != null) {
            searchSourceBuilder.version(searchSearchRequest.getVersion());
        }
    }

    protected GroupByRequest translate(GroupBy groupBy) {
        return this._groupByRequestFactory.getGroupByRequest(groupBy);
    }

    protected StatsRequest translate(Stats stats) {
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder(stats);
        return statsRequestBuilder.build();
    }
}

