/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchSourceBuilderAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CountSearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import java.io.IOException;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CountSearchRequestExecutor.class})
public class CountSearchRequestExecutorImpl
implements CountSearchRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(CountSearchRequestExecutorImpl.class);
    private CommonSearchResponseAssembler _commonSearchResponseAssembler;
    private CommonSearchSourceBuilderAssembler _commonSearchSourceBuilderAssembler;
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public CountSearchResponse execute(CountSearchRequest countSearchRequest) {
        SearchRequest searchRequest = new SearchRequest(countSearchRequest.getIndexNames());
        if (countSearchRequest.isRequestCache()) {
            searchRequest.requestCache(Boolean.valueOf(countSearchRequest.isRequestCache()));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        this._commonSearchSourceBuilderAssembler.assemble(searchSourceBuilder, (BaseSearchRequest)countSearchRequest, searchRequest);
        searchSourceBuilder.size(0);
        searchSourceBuilder.trackScores(false);
        searchSourceBuilder.trackTotalHits(true);
        SearchResponse searchResponse = this.getSearchResponse(searchRequest, countSearchRequest);
        SearchHits searchHits = searchResponse.getHits();
        CountSearchResponse countSearchResponse = new CountSearchResponse();
        TotalHits totalHits = searchHits.getTotalHits();
        countSearchResponse.setCount(totalHits.value);
        this._commonSearchResponseAssembler.assemble(searchSourceBuilder, searchResponse, (BaseSearchRequest)countSearchRequest, (BaseSearchResponse)countSearchResponse);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", countSearchResponse.getSearchRequestString(), " in ", countSearchResponse.getExecutionTime(), " ms"}));
        }
        return countSearchResponse;
    }

    protected SearchResponse getSearchResponse(SearchRequest searchRequest, CountSearchRequest countSearchRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(countSearchRequest.getConnectionId(), countSearchRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setCommonSearchResponseAssembler(CommonSearchResponseAssembler commonSearchResponseAssembler) {
        this._commonSearchResponseAssembler = commonSearchResponseAssembler;
    }

    @Reference(unbind="-")
    protected void setCommonSearchSourceBuilderAssembler(CommonSearchSourceBuilderAssembler commonSearchSourceBuilderAssembler) {
        this._commonSearchSourceBuilderAssembler = commonSearchSourceBuilderAssembler;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

