/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.UpdateIndexSettingsIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesOptions;
import com.liferay.portal.search.engine.adapter.index.UpdateIndexSettingsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.UpdateIndexSettingsIndexResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UpdateIndexSettingsIndexRequestExecutor.class})
public class UpdateIndexSettingsIndexRequestExecutorImpl
implements UpdateIndexSettingsIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndicesOptionsTranslator _indicesOptionsTranslator;

    @Override
    public UpdateIndexSettingsIndexResponse execute(UpdateIndexSettingsIndexRequest updateIndexSettingsIndexRequest) {
        UpdateSettingsRequest updateSettingsRequest = this.createUpdateSettingsRequest(updateIndexSettingsIndexRequest);
        AcknowledgedResponse acknowledgedResponse = this.getAcknowledgedResponse(updateSettingsRequest, updateIndexSettingsIndexRequest);
        return new UpdateIndexSettingsIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected UpdateSettingsRequest createUpdateSettingsRequest(UpdateIndexSettingsIndexRequest updateIndexSettingsIndexRequest) {
        UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(updateIndexSettingsIndexRequest.getIndexNames());
        updateSettingsRequest.settings(updateIndexSettingsIndexRequest.getSettings(), XContentType.JSON);
        IndicesOptions indicesOptions = updateIndexSettingsIndexRequest.getIndicesOptions();
        if (indicesOptions != null) {
            updateSettingsRequest.indicesOptions(this._indicesOptionsTranslator.translate(indicesOptions));
        }
        return updateSettingsRequest;
    }

    protected AcknowledgedResponse getAcknowledgedResponse(UpdateSettingsRequest updateSettingsRequest, UpdateIndexSettingsIndexRequest updateIndexSettingsIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(updateIndexSettingsIndexRequest.getConnectionId(), updateIndexSettingsIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.putSettings(updateSettingsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setIndicesOptionsTranslator(IndicesOptionsTranslator indicesOptionsTranslator) {
        this._indicesOptionsTranslator = indicesOptionsTranslator;
    }
}

