/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndexRequestShardFailureTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.RefreshIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndexRequestShardFailure;
import com.liferay.portal.search.engine.adapter.index.RefreshIndexRequest;
import com.liferay.portal.search.engine.adapter.index.RefreshIndexResponse;
import java.io.IOException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RefreshIndexRequestExecutor.class})
public class RefreshIndexRequestExecutorImpl
implements RefreshIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndexRequestShardFailureTranslator _indexRequestShardFailureTranslator;

    @Override
    public RefreshIndexResponse execute(RefreshIndexRequest refreshIndexRequest) {
        RefreshRequest refreshRequest = this.createRefreshRequest(refreshIndexRequest);
        RefreshResponse refreshResponse = this.getRefreshResponse(refreshRequest, refreshIndexRequest);
        RefreshIndexResponse refreshIndexResponse = new RefreshIndexResponse();
        refreshIndexResponse.setFailedShards(refreshResponse.getFailedShards());
        refreshIndexResponse.setSuccessfulShards(refreshResponse.getSuccessfulShards());
        refreshIndexResponse.setTotalShards(refreshResponse.getTotalShards());
        Object[] shardOperationFailedExceptions = refreshResponse.getShardFailures();
        if (ArrayUtil.isNotEmpty((Object[])shardOperationFailedExceptions)) {
            for (Object shardOperationFailedException : shardOperationFailedExceptions) {
                IndexRequestShardFailure indexRequestShardFailure = this._indexRequestShardFailureTranslator.translate((ShardOperationFailedException)shardOperationFailedException);
                refreshIndexResponse.addIndexRequestShardFailure(indexRequestShardFailure);
            }
        }
        return refreshIndexResponse;
    }

    protected RefreshRequest createRefreshRequest(RefreshIndexRequest refreshIndexRequest) {
        return new RefreshRequest(refreshIndexRequest.getIndexNames());
    }

    protected RefreshResponse getRefreshResponse(RefreshRequest refreshRequest, RefreshIndexRequest refreshIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(refreshIndexRequest.getConnectionId(), refreshIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.refresh(refreshRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setIndexRequestShardFailureTranslator(IndexRequestShardFailureTranslator indexRequestShardFailureTranslator) {
        this._indexRequestShardFailureTranslator = indexRequestShardFailureTranslator;
    }
}

