/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.PutMappingIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.PutMappingIndexRequest;
import com.liferay.portal.search.engine.adapter.index.PutMappingIndexResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PutMappingIndexRequestExecutor.class})
public class PutMappingIndexRequestExecutorImpl
implements PutMappingIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public PutMappingIndexResponse execute(PutMappingIndexRequest putMappingIndexRequest) {
        PutMappingRequest putMappingRequest = this.createPutMappingRequest(putMappingIndexRequest);
        AcknowledgedResponse acknowledgedResponse = this.getAcknowledgedResponse(putMappingRequest, putMappingIndexRequest);
        return new PutMappingIndexResponse(Boolean.valueOf(acknowledgedResponse.isAcknowledged()));
    }

    protected PutMappingRequest createPutMappingRequest(PutMappingIndexRequest putMappingIndexRequest) {
        PutMappingRequest putMappingRequest = new PutMappingRequest(putMappingIndexRequest.getIndexNames());
        putMappingRequest.source(putMappingIndexRequest.getMapping(), XContentType.JSON);
        putMappingRequest.type(putMappingIndexRequest.getMappingName());
        return putMappingRequest;
    }

    protected AcknowledgedResponse getAcknowledgedResponse(PutMappingRequest putMappingRequest, PutMappingIndexRequest putMappingIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(putMappingIndexRequest.getConnectionId(), putMappingIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.putMapping(putMappingRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

