/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.GetMappingIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.GetMappingIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetMappingIndexResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.compress.CompressedXContent;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GetMappingIndexRequestExecutor.class})
public class GetMappingIndexRequestExecutorImpl
implements GetMappingIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public GetMappingIndexResponse execute(GetMappingIndexRequest getMappingIndexRequest) {
        GetMappingsRequest getMappingsRequest = this.createGetMappingsRequest(getMappingIndexRequest);
        GetMappingsResponse getMappingsResponse = this.getGetMappingsResponse(getMappingsRequest, getMappingIndexRequest);
        Map mappings = getMappingsResponse.mappings();
        HashMap<String, String> indexMappings = new HashMap<String, String>();
        for (String indexName : getMappingIndexRequest.getIndexNames()) {
            MappingMetadata mappingMetadata = (MappingMetadata)mappings.get(indexName);
            CompressedXContent mappingContent = mappingMetadata.source();
            indexMappings.put(indexName, mappingContent.toString());
        }
        return new GetMappingIndexResponse(indexMappings);
    }

    protected GetMappingsRequest createGetMappingsRequest(GetMappingIndexRequest getMappingIndexRequest) {
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(getMappingIndexRequest.getIndexNames());
        return getMappingsRequest;
    }

    protected GetMappingsResponse getGetMappingsResponse(GetMappingsRequest getMappingsRequest, GetMappingIndexRequest getMappingIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(getMappingIndexRequest.getConnectionId(), getMappingIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.getMapping(getMappingsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

