/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.GetIndexIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.GetIndexIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetIndexIndexResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetIndexIndexRequestExecutor.class})
public class GetIndexIndexRequestExecutorImpl
implements GetIndexIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public GetIndexIndexResponse execute(GetIndexIndexRequest getIndexIndexRequest) {
        GetIndexRequest getIndexRequest = this.createGetIndexRequest(getIndexIndexRequest);
        GetIndexResponse getIndexResponse = this.getGetIndexResponse(getIndexRequest, getIndexIndexRequest);
        GetIndexIndexResponse getIndexIndexResponse = new GetIndexIndexResponse();
        getIndexIndexResponse.setIndexNames(getIndexResponse.getIndices());
        ImmutableOpenMap indicesMappings = getIndexResponse.getMappings();
        getIndexIndexResponse.setMappings(this.convertMappings((ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>>)indicesMappings));
        ImmutableOpenMap indicesSettings = getIndexResponse.getSettings();
        getIndexIndexResponse.setSettings(this.convertSettings((ImmutableOpenMap<String, Settings>)indicesSettings));
        return getIndexIndexResponse;
    }

    protected Map<String, Map<String, String>> convertMappings(ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> indicesMappings) {
        Iterator iterator = indicesMappings.iterator();
        HashMap<String, Map<String, String>> indexMappings = new HashMap<String, Map<String, String>>();
        while (iterator.hasNext()) {
            ObjectObjectCursor objectObjectCursor = (ObjectObjectCursor)iterator.next();
            ImmutableOpenMap typeMappingsData = (ImmutableOpenMap)objectObjectCursor.value;
            HashMap<Object, String> indiceTypeMappings = new HashMap<Object, String>();
            indexMappings.put((String)objectObjectCursor.key, indiceTypeMappings);
            for (ObjectObjectCursor typeMappingsObjectObjectCursor : typeMappingsData) {
                MappingMetadata mappingMetadata = (MappingMetadata)typeMappingsObjectObjectCursor.value;
                CompressedXContent mappingContent = mappingMetadata.source();
                indiceTypeMappings.put(typeMappingsObjectObjectCursor.key, mappingContent.toString());
            }
        }
        return indexMappings;
    }

    protected Map<String, String> convertSettings(ImmutableOpenMap<String, Settings> indicesSettings) {
        Iterator iterator = indicesSettings.iterator();
        HashMap<String, String> indicesSettingsMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            ObjectObjectCursor objectObjectCursor = (ObjectObjectCursor)iterator.next();
            Settings settings = (Settings)objectObjectCursor.value;
            indicesSettingsMap.put((String)objectObjectCursor.key, settings.toString());
        }
        return indicesSettingsMap;
    }

    protected GetIndexRequest createGetIndexRequest(GetIndexIndexRequest getIndexIndexRequest) {
        GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(getIndexIndexRequest.getIndexNames());
        return getIndexRequest;
    }

    protected GetIndexResponse getGetIndexResponse(GetIndexRequest getIndexRequest, GetIndexIndexRequest getIndexIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(getIndexIndexRequest.getConnectionId(), getIndexIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.get(getIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

