/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.DeleteIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexRequest;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexResponse;
import java.io.IOException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DeleteIndexRequestExecutor.class})
public class DeleteIndexRequestExecutorImpl
implements DeleteIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndicesOptionsTranslator _indicesOptionsTranslator;

    @Override
    public DeleteIndexResponse execute(DeleteIndexRequest deleteIndexRequest) {
        org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest elasticsearchDeleteIndexRequest = this.createDeleteIndexRequest(deleteIndexRequest);
        AcknowledgedResponse acknowledgedResponse = this.getAcknowledgedResponse(elasticsearchDeleteIndexRequest, deleteIndexRequest);
        return new DeleteIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest createDeleteIndexRequest(DeleteIndexRequest deleteIndexRequest) {
        org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest elasticsearchDeleteIndexRequest = new org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest(deleteIndexRequest.getIndexNames());
        IndicesOptions indicesOptions = this._indicesOptionsTranslator.translate(deleteIndexRequest.getIndicesOptions());
        elasticsearchDeleteIndexRequest.indicesOptions(indicesOptions);
        return elasticsearchDeleteIndexRequest;
    }

    protected AcknowledgedResponse getAcknowledgedResponse(org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest elasticsearchDeleteIndexRequest, DeleteIndexRequest deleteIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(deleteIndexRequest.getConnectionId(), deleteIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.delete(elasticsearchDeleteIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setIndicesOptionsTranslator(IndicesOptionsTranslator indicesOptionsTranslator) {
        this._indicesOptionsTranslator = indicesOptionsTranslator;
    }
}

