/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.CreateIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.util.ClassLoaderUtil;
import com.liferay.portal.search.elasticsearch7.internal.util.SearchLogHelperUtil;
import com.liferay.portal.search.engine.adapter.index.CreateIndexRequest;
import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CreateIndexRequestExecutor.class})
public class CreateIndexRequestExecutorImpl
implements CreateIndexRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(CreateIndexRequestExecutorImpl.class);
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public com.liferay.portal.search.engine.adapter.index.CreateIndexResponse execute(CreateIndexRequest createIndexRequest) {
        org.elasticsearch.action.admin.indices.create.CreateIndexRequest elasticsearchCreateIndexRequest = this.createCreateIndexRequest(createIndexRequest);
        CreateIndexResponse elasticsearchCreateIndexResponse = this.getCreateIndexResponse(elasticsearchCreateIndexRequest, createIndexRequest);
        SearchLogHelperUtil.logActionResponse(_log, (ActionResponse)elasticsearchCreateIndexResponse);
        return new com.liferay.portal.search.engine.adapter.index.CreateIndexResponse(elasticsearchCreateIndexResponse.isAcknowledged(), elasticsearchCreateIndexResponse.index());
    }

    protected org.elasticsearch.action.admin.indices.create.CreateIndexRequest createCreateIndexRequest(CreateIndexRequest createIndexRequest) {
        org.elasticsearch.action.admin.indices.create.CreateIndexRequest elasticsearchCreateIndexRequest = new org.elasticsearch.action.admin.indices.create.CreateIndexRequest(createIndexRequest.getIndexName());
        if (createIndexRequest.getSource() != null) {
            ClassLoaderUtil.getWithContextClassLoader(() -> elasticsearchCreateIndexRequest.source(createIndexRequest.getSource(), XContentType.JSON), this.getClass());
        }
        return elasticsearchCreateIndexRequest;
    }

    protected CreateIndexResponse getCreateIndexResponse(org.elasticsearch.action.admin.indices.create.CreateIndexRequest elasticsearchCreateIndexRequest, CreateIndexRequest createIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(createIndexRequest.getConnectionId(), createIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.create(elasticsearchCreateIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

