/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.AnalyzeIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.AnalysisIndexResponseToken;
import com.liferay.portal.search.engine.adapter.index.AnalyzeIndexRequest;
import com.liferay.portal.search.engine.adapter.index.AnalyzeIndexResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.AnalyzeRequest;
import org.elasticsearch.client.indices.AnalyzeResponse;
import org.elasticsearch.client.indices.DetailAnalyzeResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyzeIndexRequestExecutor.class})
public class AnalyzeIndexRequestExecutorImpl
implements AnalyzeIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public AnalyzeIndexResponse execute(AnalyzeIndexRequest analyzeIndexRequest) {
        AnalyzeRequest analyzeRequest = this.createAnalyzeRequest(analyzeIndexRequest);
        AnalyzeResponse analyzeResponse = this.getAnalyzeResponse(analyzeRequest, analyzeIndexRequest);
        AnalyzeIndexResponse analyzeIndexResponse = new AnalyzeIndexResponse();
        if (analyzeResponse.detail() != null) {
            this.processDetailAnalyzeResponse(analyzeIndexResponse, analyzeResponse.detail());
        } else {
            List<AnalysisIndexResponseToken> analysisIndexResponseTokens = this.translateAnalyzeResponseTokens(analyzeResponse.getTokens());
            analyzeIndexResponse.addAnalysisIndexResponseTokens(analysisIndexResponseTokens);
        }
        return analyzeIndexResponse;
    }

    protected AnalyzeRequest createAnalyzeRequest(AnalyzeIndexRequest analyzeIndexRequest) {
        AnalyzeRequest analyzeRequest;
        if (Validator.isNotNull((String)analyzeIndexRequest.getAnalyzer())) {
            analyzeRequest = AnalyzeRequest.withIndexAnalyzer((String)analyzeIndexRequest.getIndexName(), (String)analyzeIndexRequest.getAnalyzer(), (String[])analyzeIndexRequest.getTexts());
        } else if (Validator.isNotNull((String)analyzeIndexRequest.getFieldName())) {
            analyzeRequest = AnalyzeRequest.withField((String)analyzeIndexRequest.getIndexName(), (String)analyzeIndexRequest.getFieldName(), (String[])analyzeIndexRequest.getTexts());
        } else if (Validator.isNotNull((String)analyzeIndexRequest.getNormalizer())) {
            analyzeRequest = AnalyzeRequest.withNormalizer((String)analyzeIndexRequest.getIndexName(), (String)analyzeIndexRequest.getNormalizer(), (String[])analyzeIndexRequest.getTexts());
        } else {
            AnalyzeRequest.CustomAnalyzerBuilder customAnalyzerBuilder = Validator.isNotNull((String)analyzeIndexRequest.getTokenizer()) ? AnalyzeRequest.buildCustomAnalyzer((String)analyzeIndexRequest.getIndexName(), (String)analyzeIndexRequest.getTokenizer()) : AnalyzeRequest.buildCustomNormalizer((String)analyzeIndexRequest.getIndexName());
            analyzeRequest = this.createAnalyzeRequest(customAnalyzerBuilder, analyzeIndexRequest);
        }
        analyzeRequest.attributes(analyzeIndexRequest.getAttributesArray());
        analyzeRequest.explain(analyzeIndexRequest.isExplain());
        return analyzeRequest;
    }

    protected AnalyzeRequest createAnalyzeRequest(AnalyzeRequest.CustomAnalyzerBuilder customAnalyzerBuilder, AnalyzeIndexRequest analyzeIndexRequest) {
        for (String charFilter : analyzeIndexRequest.getCharFilters()) {
            customAnalyzerBuilder.addCharFilter(charFilter);
        }
        for (String tokenFilter : analyzeIndexRequest.getTokenFilters()) {
            customAnalyzerBuilder.addTokenFilter(tokenFilter);
        }
        return customAnalyzerBuilder.build(analyzeIndexRequest.getTexts());
    }

    protected AnalyzeResponse getAnalyzeResponse(AnalyzeRequest analyzeRequest, AnalyzeIndexRequest analyzeIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(analyzeIndexRequest.getConnectionId(), analyzeIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.analyze(analyzeRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected void processDetailAnalyzeResponse(AnalyzeIndexResponse analyzeIndexResponse, DetailAnalyzeResponse detailAnalyzeResponse) {
        if (detailAnalyzeResponse.analyzer() != null) {
            DetailAnalyzeResponse.AnalyzeTokenList analyzeTokenList = detailAnalyzeResponse.analyzer();
            String analyzerName = analyzeTokenList.getName();
            List<AnalysisIndexResponseToken> analysisIndexResponseTokens = this.translateAnalyzeResponseTokens(ListUtil.fromArray((Object[])analyzeTokenList.getTokens()));
            AnalyzeIndexResponse.DetailsAnalyzer detailsAnalyzer = new AnalyzeIndexResponse.DetailsAnalyzer(analyzerName, analysisIndexResponseTokens);
            analyzeIndexResponse.setDetailsAnalyzer(detailsAnalyzer);
        } else {
            DetailAnalyzeResponse.AnalyzeTokenList[] analyzeTokenLists;
            DetailAnalyzeResponse.CharFilteredText[] charFilteredTexts;
            ArrayList<AnalyzeIndexResponse.DetailsCharFilter> detailsCharFilters = new ArrayList<AnalyzeIndexResponse.DetailsCharFilter>();
            for (DetailAnalyzeResponse.CharFilteredText charFilteredText : charFilteredTexts = detailAnalyzeResponse.charfilters()) {
                String charFilterName = charFilteredText.getName();
                String[] charFilterTexts = charFilteredText.getTexts();
                AnalyzeIndexResponse.DetailsCharFilter detailsCharFilter = new AnalyzeIndexResponse.DetailsCharFilter(charFilterName, charFilterTexts);
                detailsCharFilters.add(detailsCharFilter);
            }
            analyzeIndexResponse.setDetailsCharFilters(detailsCharFilters);
            ArrayList<AnalyzeIndexResponse.DetailsTokenFilter> detailsTokenFilters = new ArrayList<AnalyzeIndexResponse.DetailsTokenFilter>();
            for (DetailAnalyzeResponse.AnalyzeTokenList analyzeTokenList : analyzeTokenLists = detailAnalyzeResponse.tokenfilters()) {
                String tokenFilterName = analyzeTokenList.getName();
                List<AnalysisIndexResponseToken> analysisIndexResponseTokens = this.translateAnalyzeResponseTokens(ListUtil.fromArray((Object[])analyzeTokenList.getTokens()));
                AnalyzeIndexResponse.DetailsTokenFilter detailsTokenFilter = new AnalyzeIndexResponse.DetailsTokenFilter(tokenFilterName, analysisIndexResponseTokens);
                detailsTokenFilters.add(detailsTokenFilter);
            }
            analyzeIndexResponse.setDetailsTokenFilters(detailsTokenFilters);
            DetailAnalyzeResponse.AnalyzeTokenList tokenizerAnalyzeTokenList = detailAnalyzeResponse.tokenizer();
            String tokenizerName = tokenizerAnalyzeTokenList.getName();
            List<AnalysisIndexResponseToken> analysisIndexResponseTokens = this.translateAnalyzeResponseTokens(ListUtil.fromArray((Object[])tokenizerAnalyzeTokenList.getTokens()));
            AnalyzeIndexResponse.DetailsTokenizer detailsTokenizer = new AnalyzeIndexResponse.DetailsTokenizer(tokenizerName, analysisIndexResponseTokens);
            analyzeIndexResponse.setDetailsTokenizer(detailsTokenizer);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    protected List<AnalysisIndexResponseToken> translateAnalyzeResponseTokens(List<AnalyzeResponse.AnalyzeToken> analyzeTokens) {
        ArrayList<AnalysisIndexResponseToken> analysisIndexResponseTokens = new ArrayList<AnalysisIndexResponseToken>();
        for (AnalyzeResponse.AnalyzeToken analyzeToken : analyzeTokens) {
            AnalysisIndexResponseToken analysisIndexResponseToken = new AnalysisIndexResponseToken(analyzeToken.getTerm());
            analysisIndexResponseToken.setAttributes(analyzeToken.getAttributes());
            analysisIndexResponseToken.setEndOffset(analyzeToken.getEndOffset());
            analysisIndexResponseToken.setPosition(analyzeToken.getPosition());
            analysisIndexResponseToken.setPositionLength(analyzeToken.getPositionLength());
            analysisIndexResponseToken.setStartOffset(analyzeToken.getStartOffset());
            analysisIndexResponseToken.setType(analyzeToken.getType());
            analysisIndexResponseTokens.add(analysisIndexResponseToken);
        }
        return analysisIndexResponseTokens;
    }
}

