/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.IndexDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentResponse;
import java.io.IOException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexDocumentRequestExecutor.class})
public class IndexDocumentRequestExecutorImpl
implements IndexDocumentRequestExecutor {
    private BulkableDocumentRequestTranslator _bulkableDocumentRequestTranslator;
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public IndexDocumentResponse execute(IndexDocumentRequest indexDocumentRequest) {
        IndexRequest indexRequest = (IndexRequest)this._bulkableDocumentRequestTranslator.translate(indexDocumentRequest);
        IndexResponse indexResponse = this.getIndexResponse(indexRequest, indexDocumentRequest);
        RestStatus restStatus = indexResponse.status();
        return new IndexDocumentResponse(restStatus.getStatus(), indexResponse.getId());
    }

    protected IndexResponse getIndexResponse(IndexRequest indexRequest, IndexDocumentRequest indexDocumentRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(indexDocumentRequest.getConnectionId(), indexDocumentRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setBulkableDocumentRequestTranslator(BulkableDocumentRequestTranslator bulkableDocumentRequestTranslator) {
        this._bulkableDocumentRequestTranslator = bulkableDocumentRequestTranslator;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

