/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.document.DocumentFieldsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.GetDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.GetDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.GetDocumentResponse;
import com.liferay.portal.search.geolocation.GeoBuilders;
import java.io.IOException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GetDocumentRequestExecutor.class})
public class GetDocumentRequestExecutorImpl
implements GetDocumentRequestExecutor {
    private BulkableDocumentRequestTranslator _bulkableDocumentRequestTranslator;
    private DocumentBuilderFactory _documentBuilderFactory;
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private GeoBuilders _geoBuilders;

    @Override
    public GetDocumentResponse execute(GetDocumentRequest getDocumentRequest) {
        GetRequest getRequest = (GetRequest)this._bulkableDocumentRequestTranslator.translate(getDocumentRequest);
        GetResponse getResponse = this.getGetResponse(getRequest, getDocumentRequest);
        GetDocumentResponse getDocumentResponse = new GetDocumentResponse(getResponse.isExists());
        if (!getResponse.isExists()) {
            return getDocumentResponse;
        }
        getDocumentResponse.setSource(getResponse.getSourceAsString());
        getDocumentResponse.setVersion(getResponse.getVersion());
        DocumentFieldsTranslator documentFieldsTranslator = new DocumentFieldsTranslator(this._geoBuilders);
        DocumentBuilder documentBuilder = this._documentBuilderFactory.builder();
        documentFieldsTranslator.translate(documentBuilder, getResponse.getSourceAsMap());
        getDocumentResponse.setDocument(documentBuilder.build());
        return getDocumentResponse;
    }

    protected GetResponse getGetResponse(GetRequest getRequest, GetDocumentRequest getDocumentRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(getDocumentRequest.getConnectionId(), getDocumentRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.get(getRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setBulkableDocumentRequestTranslator(BulkableDocumentRequestTranslator bulkableDocumentRequestTranslator) {
        this._bulkableDocumentRequestTranslator = bulkableDocumentRequestTranslator;
    }

    @Reference(unbind="-")
    protected void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this._documentBuilderFactory = documentBuilderFactory;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setGeoBuilders(GeoBuilders geoBuilders) {
        this._geoBuilders = geoBuilders;
    }
}

