/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.document.ElasticsearchDocumentFactory;
import com.liferay.portal.search.elasticsearch7.internal.script.ScriptTranslator;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.GetDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import java.util.Collections;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Elasticsearch"}, service={BulkableDocumentRequestTranslator.class})
public class ElasticsearchBulkableDocumentRequestTranslator
implements BulkableDocumentRequestTranslator {
    private ElasticsearchDocumentFactory _elasticsearchDocumentFactory;
    private final ScriptTranslator _scriptTranslator = new ScriptTranslator();

    public DeleteRequest translate(DeleteDocumentRequest deleteDocumentRequest) {
        DeleteRequest deleteRequest = new DeleteRequest();
        this._setRefreshPolicy((WriteRequest)deleteRequest, deleteDocumentRequest.isRefresh());
        deleteRequest.id(deleteDocumentRequest.getUid());
        deleteRequest.index(deleteDocumentRequest.getIndexName());
        deleteRequest.type(deleteDocumentRequest.getType());
        return deleteRequest;
    }

    public GetRequest translate(GetDocumentRequest getDocumentRequest) {
        GetRequest getRequest = new GetRequest();
        FetchSourceContext fetchSourceContext = new FetchSourceContext(getDocumentRequest.isFetchSource(), getDocumentRequest.getFetchSourceIncludes(), getDocumentRequest.getFetchSourceExcludes());
        getRequest.fetchSourceContext(fetchSourceContext);
        getRequest.id(getDocumentRequest.getId());
        getRequest.index(getDocumentRequest.getIndexName());
        getRequest.refresh(getDocumentRequest.isRefresh());
        getRequest.storedFields(getDocumentRequest.getStoredFields());
        getRequest.type(this._getType(getDocumentRequest.getType()));
        return getRequest;
    }

    public IndexRequest translate(IndexDocumentRequest indexDocumentRequest) {
        IndexRequest indexRequest = new IndexRequest();
        this._setRefreshPolicy((WriteRequest)indexRequest, indexDocumentRequest.isRefresh());
        this._setSource(indexRequest, indexDocumentRequest);
        indexRequest.id(this._getUid(indexDocumentRequest));
        indexRequest.index(indexDocumentRequest.getIndexName());
        indexRequest.type(this._getType(indexDocumentRequest.getType()));
        return indexRequest;
    }

    public UpdateRequest translate(UpdateDocumentRequest updateDocumentRequest) {
        UpdateRequest updateRequest = new UpdateRequest();
        if (updateDocumentRequest.getScript() != null) {
            updateRequest.script(this._scriptTranslator.translate(updateDocumentRequest.getScript()));
        } else {
            this._setDoc(updateRequest, updateDocumentRequest);
        }
        this._setDocAsUpsert(updateRequest, updateDocumentRequest.isUpsert());
        this._setRefreshPolicy((WriteRequest)updateRequest, updateDocumentRequest.isRefresh());
        this._setScriptedUpsert(updateRequest, updateDocumentRequest.isScriptedUpsert());
        updateRequest.id(this._getUid(updateDocumentRequest));
        updateRequest.index(updateDocumentRequest.getIndexName());
        updateRequest.type(this._getType(updateDocumentRequest.getType()));
        return updateRequest;
    }

    @Reference(unbind="-")
    protected void setElasticsearchDocumentFactory(ElasticsearchDocumentFactory elasticsearchDocumentFactory) {
        this._elasticsearchDocumentFactory = elasticsearchDocumentFactory;
    }

    private String _getType(String type) {
        if (type != null) {
            return type;
        }
        return "_doc";
    }

    private String _getUid(IndexDocumentRequest indexDocumentRequest) {
        String uid = indexDocumentRequest.getUid();
        if (!Validator.isBlank((String)uid)) {
            return uid;
        }
        if (indexDocumentRequest.getDocument() != null) {
            com.liferay.portal.search.document.Document document = indexDocumentRequest.getDocument();
            return document.getString("uid");
        }
        Document document = indexDocumentRequest.getDocument71();
        Field field = document.getField("uid");
        if (field != null) {
            return field.getValue();
        }
        return uid;
    }

    private String _getUid(UpdateDocumentRequest updateDocumentRequest) {
        String uid = updateDocumentRequest.getUid();
        if (!Validator.isBlank((String)uid)) {
            return uid;
        }
        if (updateDocumentRequest.getDocument() != null) {
            com.liferay.portal.search.document.Document document = updateDocumentRequest.getDocument();
            return document.getString("uid");
        }
        Document document = updateDocumentRequest.getDocument71();
        Field field = document.getField("uid");
        if (field != null) {
            uid = field.getValue();
        }
        return uid;
    }

    private void _setDoc(UpdateRequest updateRequest, UpdateDocumentRequest updateDocumentRequest) {
        if (updateDocumentRequest.getDocument() != null) {
            XContentBuilder xContentBuilder = this._elasticsearchDocumentFactory.getElasticsearchDocument(updateDocumentRequest.getDocument());
            updateRequest.doc(xContentBuilder);
        } else {
            String elasticsearchDocument = this._elasticsearchDocumentFactory.getElasticsearchDocument(updateDocumentRequest.getDocument71());
            updateRequest.doc(elasticsearchDocument, XContentType.JSON);
        }
    }

    private void _setDocAsUpsert(UpdateRequest updateRequest, boolean upsert) {
        if (upsert) {
            updateRequest.docAsUpsert(true);
        }
    }

    private void _setRefreshPolicy(WriteRequest writeRequest, boolean refresh) {
        if (refresh) {
            writeRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
    }

    private void _setScriptedUpsert(UpdateRequest updateRequest, boolean scriptedUpsert) {
        if (scriptedUpsert) {
            updateRequest.scriptedUpsert(true);
            updateRequest.upsert(Collections.emptyMap());
        }
    }

    private void _setSource(IndexRequest indexRequest, IndexDocumentRequest indexDocumentRequest) {
        if (indexDocumentRequest.getDocument() != null) {
            XContentBuilder xContentBuilder = this._elasticsearchDocumentFactory.getElasticsearchDocument(indexDocumentRequest.getDocument());
            indexRequest.source(xContentBuilder);
        } else {
            String elasticsearchDocument = this._elasticsearchDocumentFactory.getElasticsearchDocument(indexDocumentRequest.getDocument71());
            indexRequest.source(elasticsearchDocument, XContentType.JSON);
        }
    }
}

