/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.DeleteByQueryDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentResponse;
import com.liferay.portal.search.query.QueryTranslator;
import java.io.IOException;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DeleteByQueryDocumentRequestExecutor.class})
public class DeleteByQueryDocumentRequestExecutorImpl
implements DeleteByQueryDocumentRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private com.liferay.portal.kernel.search.query.QueryTranslator<QueryBuilder> _legacyQueryTranslator;
    private QueryTranslator<QueryBuilder> _queryTranslator;

    @Override
    public DeleteByQueryDocumentResponse execute(DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {
        DeleteByQueryRequest deleteByQueryRequest = this.createDeleteByQueryRequest(deleteByQueryDocumentRequest);
        BulkByScrollResponse bulkByScrollResponse = this.getBulkByScrollResponse(deleteByQueryRequest, deleteByQueryDocumentRequest);
        TimeValue timeValue = bulkByScrollResponse.getTook();
        return new DeleteByQueryDocumentResponse(bulkByScrollResponse.getDeleted(), timeValue.getMillis());
    }

    protected DeleteByQueryRequest createDeleteByQueryRequest(DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest();
        deleteByQueryRequest.indices(deleteByQueryDocumentRequest.getIndexNames());
        if (deleteByQueryDocumentRequest.getPortalSearchQuery() != null) {
            QueryBuilder queryBuilder = (QueryBuilder)this._queryTranslator.translate(deleteByQueryDocumentRequest.getPortalSearchQuery());
            deleteByQueryRequest.setQuery(queryBuilder);
        } else {
            QueryBuilder queryBuilder = (QueryBuilder)this._legacyQueryTranslator.translate(deleteByQueryDocumentRequest.getQuery(), null);
            deleteByQueryRequest.setQuery(queryBuilder);
        }
        deleteByQueryRequest.setRefresh(deleteByQueryDocumentRequest.isRefresh());
        return deleteByQueryRequest;
    }

    protected BulkByScrollResponse getBulkByScrollResponse(DeleteByQueryRequest deleteByQueryRequest, DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(deleteByQueryDocumentRequest.getConnectionId(), deleteByQueryDocumentRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setLegacyQueryTranslator(com.liferay.portal.kernel.search.query.QueryTranslator<QueryBuilder> legacyQueryTranslator) {
        this._legacyQueryTranslator = legacyQueryTranslator;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setQueryTranslator(QueryTranslator<QueryBuilder> queryTranslator) {
        this._queryTranslator = queryTranslator;
    }
}

