/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.UpdateSettingsClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.UpdateSettingsClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.UpdateSettingsClusterResponse;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.client.ClusterClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UpdateSettingsClusterRequestExecutor.class})
public class UpdateSettingsClusterRequestExecutorImpl
implements UpdateSettingsClusterRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public UpdateSettingsClusterResponse execute(UpdateSettingsClusterRequest updateSettingsClusterRequest) {
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = this.createClusterUpdateSettingsRequest(updateSettingsClusterRequest);
        ClusterUpdateSettingsResponse clusterUpdateSettingsResponse = this.getClusterUpdateSettingsResponse(clusterUpdateSettingsRequest, updateSettingsClusterRequest);
        Settings persistentSettings = clusterUpdateSettingsResponse.getPersistentSettings();
        Settings transientSettings = clusterUpdateSettingsResponse.getTransientSettings();
        return new UpdateSettingsClusterResponse(persistentSettings.toString(), transientSettings.toString());
    }

    protected ClusterUpdateSettingsRequest createClusterUpdateSettingsRequest(UpdateSettingsClusterRequest updateSettingsClusterRequest) {
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = new ClusterUpdateSettingsRequest();
        Settings.Builder persistentSettingsBuilder = Settings.builder();
        Map persistentSettings = updateSettingsClusterRequest.getPersistentSettings();
        for (Map.Entry entry : persistentSettings.entrySet()) {
            persistentSettingsBuilder.put((String)entry.getKey(), (String)entry.getValue());
        }
        clusterUpdateSettingsRequest.persistentSettings(persistentSettingsBuilder);
        Settings.Builder transientSettingsBuilder = Settings.builder();
        Map transientSettings = updateSettingsClusterRequest.getTransientSettings();
        for (Map.Entry entry : transientSettings.entrySet()) {
            transientSettingsBuilder.put((String)entry.getKey(), (String)entry.getValue());
        }
        clusterUpdateSettingsRequest.transientSettings(transientSettingsBuilder);
        return clusterUpdateSettingsRequest;
    }

    protected ClusterUpdateSettingsResponse getClusterUpdateSettingsResponse(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest, UpdateSettingsClusterRequest updateSettingsClusterRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(updateSettingsClusterRequest.getConnectionId(), updateSettingsClusterRequest.isPreferLocalCluster());
        ClusterClient clusterClient = restHighLevelClient.cluster();
        try {
            return clusterClient.putSettings(clusterUpdateSettingsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

