/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.ccr;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.ccr.PauseFollowCCRRequestExecutor;
import com.liferay.portal.search.engine.adapter.ccr.PauseFollowCCRRequest;
import com.liferay.portal.search.engine.adapter.ccr.PauseFollowCCRResponse;
import java.io.IOException;
import org.elasticsearch.client.CcrClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.ccr.PauseFollowRequest;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PauseFollowCCRRequestExecutor.class})
public class PauseFollowCCRRequestExecutorImpl
implements PauseFollowCCRRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public PauseFollowCCRResponse execute(PauseFollowCCRRequest pauseFollowCCRRequest) {
        PauseFollowRequest pauseFollowRequest = this.createPauseFollowRequest(pauseFollowCCRRequest);
        AcknowledgedResponse acknowledgedResponse = this.getAcknowledgedResponse(pauseFollowRequest, pauseFollowCCRRequest);
        return new PauseFollowCCRResponse(acknowledgedResponse.isAcknowledged());
    }

    protected PauseFollowRequest createPauseFollowRequest(PauseFollowCCRRequest pauseFollowCCRRequest) {
        return new PauseFollowRequest(pauseFollowCCRRequest.getIndexName());
    }

    protected AcknowledgedResponse getAcknowledgedResponse(PauseFollowRequest pauseFollowRequest, PauseFollowCCRRequest pauseFollowCCRRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(pauseFollowCCRRequest.getConnectionId(), pauseFollowCCRRequest.isPreferLocalCluster());
        CcrClient ccrClient = restHighLevelClient.ccr();
        try {
            return ccrClient.pauseFollow(pauseFollowRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

