/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.portal.search.elasticsearch7.internal.query.GeoDistanceQueryTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.geolocation.GeoValidationMethodTranslator;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.query.GeoDistanceQuery;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;

@Component(service={GeoDistanceQueryTranslator.class})
public class GeoDistanceQueryTranslatorImpl
implements GeoDistanceQueryTranslator {
    private final GeoValidationMethodTranslator _geoValidationMethodTranslator = new GeoValidationMethodTranslator();

    @Override
    public QueryBuilder translate(GeoDistanceQuery geoDistanceQuery) {
        GeoDistanceQueryBuilder geoDistanceQueryBuilder = QueryBuilders.geoDistanceQuery((String)geoDistanceQuery.getField());
        geoDistanceQueryBuilder.distance(String.valueOf(geoDistanceQuery.getGeoDistance()));
        GeoLocationPoint pinGeoLocationPoint = geoDistanceQuery.getPinGeoLocationPoint();
        geoDistanceQueryBuilder.point(pinGeoLocationPoint.getLatitude().doubleValue(), pinGeoLocationPoint.getLongitude().doubleValue());
        if (geoDistanceQuery.getGeoValidationMethod() != null) {
            geoDistanceQueryBuilder.setValidationMethod(this._geoValidationMethodTranslator.translate(geoDistanceQuery.getGeoValidationMethod()));
        }
        if (geoDistanceQuery.getIgnoreUnmapped() != null) {
            geoDistanceQueryBuilder.ignoreUnmapped(geoDistanceQuery.getIgnoreUnmapped().booleanValue());
        }
        return geoDistanceQueryBuilder;
    }
}

