/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.portal.search.elasticsearch7.internal.query.BoostingQueryTranslator;
import com.liferay.portal.search.query.BoostingQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.QueryVisitor;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;

@Component(service={BoostingQueryTranslator.class})
public class BoostingQueryTranslatorImpl
implements BoostingQueryTranslator {
    @Override
    public QueryBuilder translate(BoostingQuery boostingQuery, QueryVisitor<QueryBuilder> queryVisitor) {
        Query positiveQuery = boostingQuery.getPositiveQuery();
        QueryBuilder positiveQueryBuilder = (QueryBuilder)positiveQuery.accept(queryVisitor);
        Query negativeQuery = boostingQuery.getNegativeQuery();
        QueryBuilder negativeQueryBuilder = (QueryBuilder)negativeQuery.accept(queryVisitor);
        BoostingQueryBuilder boostingQueryBuilder = QueryBuilders.boostingQuery((QueryBuilder)positiveQueryBuilder, (QueryBuilder)negativeQueryBuilder);
        Float negativeBoost = boostingQuery.getNegativeBoost();
        if (negativeBoost != null) {
            boostingQueryBuilder.negativeBoost(negativeBoost.floatValue());
        }
        return boostingQueryBuilder;
    }
}

