/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.portal.search.elasticsearch7.internal.query.BooleanQueryTranslator;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.QueryVisitor;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;

@Component(service={BooleanQueryTranslator.class})
public class BooleanQueryTranslatorImpl
implements BooleanQueryTranslator {
    @Override
    public QueryBuilder translate(BooleanQuery booleanQuery, QueryVisitor<QueryBuilder> queryVisitor) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        this.processQueryClause(booleanQuery.getMustQueryClauses(), queryVisitor, arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0));
        this.processQueryClause(booleanQuery.getMustNotQueryClauses(), queryVisitor, arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).mustNot(arg_0));
        this.processQueryClause(booleanQuery.getShouldQueryClauses(), queryVisitor, arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).should(arg_0));
        this.processQueryClause(booleanQuery.getFilterQueryClauses(), queryVisitor, arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0));
        if (booleanQuery.getAdjustPureNegative() != null) {
            boolQueryBuilder.adjustPureNegative(booleanQuery.getAdjustPureNegative().booleanValue());
        }
        if (booleanQuery.getMinimumShouldMatch() != null) {
            boolQueryBuilder.minimumShouldMatch(booleanQuery.getMinimumShouldMatch().intValue());
        }
        boolQueryBuilder.queryName(booleanQuery.getQueryName());
        return boolQueryBuilder;
    }

    protected void processQueryClause(List<Query> queryClauses, QueryVisitor<QueryBuilder> queryVisitor, QueryBuilderConsumer queryBuilderConsumer) {
        for (Query query : queryClauses) {
            QueryBuilder queryBuilder = (QueryBuilder)query.accept(queryVisitor);
            queryBuilderConsumer.accept(queryBuilder);
        }
    }

    protected static interface QueryBuilderConsumer {
        public void accept(QueryBuilder var1);
    }
}

