/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.legacy.query;

import com.liferay.portal.kernel.search.generic.MoreLikeThisQuery;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.legacy.query.MoreLikeThisQueryTranslator;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={MoreLikeThisQueryTranslator.class})
public class MoreLikeThisQueryTranslatorImpl
implements MoreLikeThisQueryTranslator {
    @Reference
    protected IndexNameBuilder indexNameBuilder;

    @Override
    public QueryBuilder translate(MoreLikeThisQuery moreLikeThisQuery) {
        Set stopWords;
        ArrayList<MoreLikeThisQueryBuilder.Item> likeItems = new ArrayList<MoreLikeThisQueryBuilder.Item>();
        if (moreLikeThisQuery.getDocumentUIDs() != null) {
            String type = moreLikeThisQuery.getType();
            if (Validator.isNotNull((String)type)) {
                type = "LiferayDocumentType";
            }
            for (String documentUID : moreLikeThisQuery.getDocumentUIDs()) {
                MoreLikeThisQueryBuilder.Item moreLikeThisQueryBuilderItem = new MoreLikeThisQueryBuilder.Item(this.indexNameBuilder.getIndexName(moreLikeThisQuery.getCompanyId()), type, documentUID);
                likeItems.add(moreLikeThisQueryBuilderItem);
            }
        }
        List fields = moreLikeThisQuery.getFields();
        String[] fieldsArray = null;
        if (!fields.isEmpty()) {
            fieldsArray = fields.toArray(new String[0]);
        }
        ArrayList<String> likeTexts = new ArrayList<String>();
        if (Validator.isNotNull((String)moreLikeThisQuery.getLikeText())) {
            likeTexts.add(moreLikeThisQuery.getLikeText());
        }
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((String[])fieldsArray, (String[])likeTexts.toArray(new String[0]), (MoreLikeThisQueryBuilder.Item[])likeItems.toArray(new MoreLikeThisQueryBuilder.Item[0]));
        if (Validator.isNotNull((String)moreLikeThisQuery.getAnalyzer())) {
            moreLikeThisQueryBuilder.analyzer(moreLikeThisQuery.getAnalyzer());
        }
        if (moreLikeThisQuery.getMaxDocFrequency() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(moreLikeThisQuery.getMaxDocFrequency().intValue());
        }
        if (moreLikeThisQuery.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(moreLikeThisQuery.getMaxQueryTerms().intValue());
        }
        if (moreLikeThisQuery.getMaxWordLength() != null) {
            moreLikeThisQueryBuilder.maxWordLength(moreLikeThisQuery.getMaxWordLength().intValue());
        }
        if (moreLikeThisQuery.getMinDocFrequency() != null) {
            moreLikeThisQueryBuilder.minDocFreq(moreLikeThisQuery.getMinDocFrequency().intValue());
        }
        if (Validator.isNotNull((String)moreLikeThisQuery.getMinShouldMatch())) {
            moreLikeThisQueryBuilder.minimumShouldMatch(moreLikeThisQuery.getMinShouldMatch());
        }
        if (moreLikeThisQuery.getMinTermFrequency() != null) {
            moreLikeThisQueryBuilder.minTermFreq(moreLikeThisQuery.getMinTermFrequency().intValue());
        }
        if (moreLikeThisQuery.getMinWordLength() != null) {
            moreLikeThisQueryBuilder.minWordLength(moreLikeThisQuery.getMinWordLength().intValue());
        }
        if (!moreLikeThisQuery.isDefaultBoost()) {
            moreLikeThisQueryBuilder.boost(moreLikeThisQuery.getBoost());
        }
        if (!(stopWords = moreLikeThisQuery.getStopWords()).isEmpty()) {
            moreLikeThisQueryBuilder.stopWords(stopWords.toArray(new String[0]));
        }
        if (moreLikeThisQuery.getTermBoost() != null) {
            moreLikeThisQueryBuilder.boostTerms(moreLikeThisQuery.getTermBoost().floatValue());
        }
        if (moreLikeThisQuery.isIncludeInput() != null) {
            moreLikeThisQueryBuilder.include(moreLikeThisQuery.isIncludeInput().booleanValue());
        }
        return moreLikeThisQueryBuilder;
    }
}

