/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.information;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConnectionConfiguration;
import com.liferay.portal.search.elasticsearch7.internal.ElasticsearchSearchEngine;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.configuration.OperationModeResolver;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.engine.ConnectionInformation;
import com.liferay.portal.search.engine.ConnectionInformationBuilder;
import com.liferay.portal.search.engine.ConnectionInformationBuilderFactory;
import com.liferay.portal.search.engine.NodeInformation;
import com.liferay.portal.search.engine.NodeInformationBuilder;
import com.liferay.portal.search.engine.NodeInformationBuilderFactory;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.cluster.ClusterHealthStatus;
import com.liferay.portal.search.engine.adapter.cluster.ClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterResponse;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.Version;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchEngineInformation.class})
public class ElasticsearchSearchEngineInformation
implements SearchEngineInformation {
    @Reference
    protected ConfigurationAdmin configurationAdmin;
    @Reference
    protected ConnectionInformationBuilderFactory connectionInformationBuilderFactory;
    @Reference
    protected volatile ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected ElasticsearchSearchEngine elasticsearchSearchEngine;
    @Reference
    protected NodeInformationBuilderFactory nodeInformationBuilderFactory;
    @Reference
    protected OperationModeResolver operationModeResolver;
    @Reference
    protected SearchEngineAdapter searchEngineAdapter;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchSearchEngineInformation.class);

    public String getClientVersionString() {
        return Version.CURRENT.toString();
    }

    public List<ConnectionInformation> getConnectionInformationList() {
        LinkedList<ConnectionInformation> connectionInformationList;
        block5: {
            connectionInformationList = new LinkedList<ConnectionInformation>();
            this.addMainConnection(this.elasticsearchConnectionManager.getElasticsearchConnection(), connectionInformationList);
            String filterString = String.format("(&(service.factoryPid=%s)(active=%s)", ElasticsearchConnectionConfiguration.class.getName(), true);
            if (this.operationModeResolver.isProductionModeEnabled() && !Validator.isBlank((String)this.elasticsearchConfigurationWrapper.remoteClusterConnectionId())) {
                filterString = filterString.concat(String.format("(!(connectionId=%s))", this.elasticsearchConfigurationWrapper.remoteClusterConnectionId()));
            }
            if (this.operationModeResolver.isProductionModeEnabled() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled()) {
                this.addCCRConnection(this.elasticsearchConnectionManager.getElasticsearchConnection(true), connectionInformationList);
                String connectionId = this.elasticsearchConnectionManager.getLocalClusterConnectionId();
                if (!Validator.isBlank((String)connectionId)) {
                    filterString = filterString.concat(String.format("(!(connectionId=%s))", connectionId));
                }
            }
            filterString = filterString.concat(")");
            try {
                this.addActiveConnections(filterString, connectionInformationList);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to get active connections", (Throwable)exception);
            }
        }
        return connectionInformationList;
    }

    public String getNodesString() {
        try {
            String localClusterNodesString;
            String clusterNodesString = this.getClusterNodesString(this.elasticsearchConnectionManager.getRestHighLevelClient());
            if (this.operationModeResolver.isProductionModeEnabled() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled() && !Validator.isBlank((String)(localClusterNodesString = this.getClusterNodesString(this.elasticsearchConnectionManager.getRestHighLevelClient(null, true))))) {
                StringBundler sb = new StringBundler(11);
                sb.append("Remote Cluster");
                sb.append(" ");
                sb.append("=");
                sb.append(" ");
                sb.append(clusterNodesString);
                sb.append(", ");
                sb.append("Local Cluster");
                sb.append(" ");
                sb.append("=");
                sb.append(" ");
                sb.append(localClusterNodesString);
                clusterNodesString = sb.toString();
            }
            return clusterNodesString;
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public String getVendorString() {
        String vendor = this.elasticsearchSearchEngine.getVendor();
        if (this.operationModeResolver.isDevelopmentModeEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append(vendor);
            sb.append(" ");
            sb.append("(");
            sb.append("Sidecar");
            sb.append(")");
            return sb.toString();
        }
        return vendor;
    }

    protected void addActiveConnections(String filterString, List<ConnectionInformation> connectionInformationList) throws Exception {
        Object[] configurations = this.configurationAdmin.listConfigurations(filterString);
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            return;
        }
        for (Object configuration : configurations) {
            Dictionary properties = configuration.getProperties();
            String connectionId = (String)properties.get("connectionId");
            this.addConnectionInformation(this.elasticsearchConnectionManager.getElasticsearchConnection(connectionId), connectionInformationList, null);
        }
    }

    protected void addCCRConnection(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList) {
        this.addConnectionInformation(elasticsearchConnection, connectionInformationList, "read");
    }

    protected void addConnectionInformation(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList, String ... labels) {
        ConnectionInformationBuilder connectionInformationBuilder;
        block7: {
            block6: {
                if (elasticsearchConnection == null) {
                    return;
                }
                connectionInformationBuilder = this.connectionInformationBuilderFactory.getConnectionInformationBuilder();
                try {
                    this._setClusterAndNodeInformation(connectionInformationBuilder, elasticsearchConnection.getRestHighLevelClient());
                }
                catch (Exception exception) {
                    connectionInformationBuilder.error(exception.toString());
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)"Unable to get node information", (Throwable)exception);
                }
            }
            connectionInformationBuilder.connectionId(elasticsearchConnection.getConnectionId());
            try {
                this._setHealthInformation(connectionInformationBuilder, elasticsearchConnection.getConnectionId());
            }
            catch (RuntimeException runtimeException) {
                connectionInformationBuilder.health("unknown");
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)"Unable to get health information", (Throwable)runtimeException);
            }
        }
        if (ArrayUtil.isNotEmpty((Object[])labels)) {
            connectionInformationBuilder.labels(SetUtil.fromArray((Object[])labels));
        }
        connectionInformationList.add(connectionInformationBuilder.build());
    }

    protected void addMainConnection(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList) {
        String[] labels = new String[]{"read", "write"};
        if (this.operationModeResolver.isProductionModeEnabled() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled()) {
            labels = new String[]{"write"};
        }
        this.addConnectionInformation(elasticsearchConnection, connectionInformationList, labels);
    }

    protected String getClusterNodesString(RestHighLevelClient restHighLevelClient) {
        try {
            if (restHighLevelClient == null) {
                return "";
            }
            ConnectionInformationBuilder connectionInformationBuilder = this.connectionInformationBuilderFactory.getConnectionInformationBuilder();
            this._setClusterAndNodeInformation(connectionInformationBuilder, restHighLevelClient);
            ConnectionInformation connectionInformation = connectionInformationBuilder.build();
            String clusterName = connectionInformation.getClusterName();
            List nodeInformations = connectionInformation.getNodeInformationList();
            Stream stream = nodeInformations.stream();
            String nodesString = stream.map(nodeInfo -> {
                StringBundler sb = new StringBundler(5);
                sb.append(nodeInfo.getName());
                sb.append(" ");
                sb.append("(");
                sb.append(nodeInfo.getVersion());
                sb.append(")");
                return sb.toString();
            }).collect(Collectors.joining(", "));
            StringBundler sb = new StringBundler(6);
            sb.append(clusterName);
            sb.append(":");
            sb.append(" ");
            sb.append("[");
            sb.append(nodesString);
            sb.append("]");
            return sb.toString();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get node information", (Throwable)exception);
            }
            StringBundler sb = new StringBundler(6);
            sb.append("(");
            sb.append("Error");
            sb.append(":");
            sb.append(" ");
            sb.append(exception.toString());
            sb.append(")");
            return sb.toString();
        }
    }

    private void _setClusterAndNodeInformation(ConnectionInformationBuilder connectionInformationBuilder, RestHighLevelClient restHighLevelClient) throws Exception {
        RestClient restClient = restHighLevelClient.getLowLevelClient();
        String endpoint = "/_nodes";
        Request request = new Request("GET", endpoint);
        request.addParameter("timeout", "10000ms");
        Response response = restClient.performRequest(request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject((String)responseBody);
        String clusterName = GetterUtil.getString((Object)responseJSONObject.get("cluster_name"));
        connectionInformationBuilder.clusterName(clusterName);
        JSONObject nodesJSONObject = responseJSONObject.getJSONObject("nodes");
        Set nodes = nodesJSONObject.keySet();
        ArrayList<NodeInformation> nodeInformationList = new ArrayList<NodeInformation>();
        for (String node : nodes) {
            JSONObject nodeJSONObject = nodesJSONObject.getJSONObject(node);
            NodeInformationBuilder nodeInformationBuilder = this.nodeInformationBuilderFactory.getNodeInformationBuilder();
            nodeInformationBuilder.name(GetterUtil.getString((Object)nodeJSONObject.get("name")));
            nodeInformationBuilder.version(GetterUtil.getString((Object)nodeJSONObject.get("version")));
            nodeInformationList.add(nodeInformationBuilder.build());
        }
        connectionInformationBuilder.nodeInformationList(nodeInformationList);
    }

    private void _setHealthInformation(ConnectionInformationBuilder connectionInformationBuilder, String connectionId) {
        HealthClusterRequest healthClusterRequest = new HealthClusterRequest();
        healthClusterRequest.setConnectionId(connectionId);
        healthClusterRequest.setTimeout(1000L);
        HealthClusterResponse healthClusterResponse = (HealthClusterResponse)this.searchEngineAdapter.execute((ClusterRequest)healthClusterRequest);
        ClusterHealthStatus clusterHealthStatus = healthClusterResponse.getClusterHealthStatus();
        connectionInformationBuilder.health(clusterHealthStatus.toString());
    }
}

