/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index.contributor;

import com.liferay.portal.search.elasticsearch7.internal.index.contributor.IndexContributorReceiver;
import com.liferay.portal.search.spi.model.index.contributor.IndexContributor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={IndexContributorsHolder.class})
public class IndexContributorsHolder {
    private final List<IndexContributorReceiver> _indexContributorReceivers = new CopyOnWriteArrayList<IndexContributorReceiver>();
    private final List<IndexContributor> _indexContributors = new CopyOnWriteArrayList<IndexContributor>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addIndexContributor(IndexContributor indexContributor) {
        for (IndexContributorReceiver indexContributorReceiver : this._indexContributorReceivers) {
            indexContributorReceiver.addIndexContributor(indexContributor);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addIndexContributorReceiver(IndexContributorReceiver indexContributorReceiver) {
        this._indexContributorReceivers.add(indexContributorReceiver);
        for (IndexContributor indexContributor : this._indexContributors) {
            indexContributorReceiver.addIndexContributor(indexContributor);
        }
    }

    protected void removeIndexContributor(IndexContributor indexContributor) {
        this._indexContributors.remove(indexContributor);
        for (IndexContributorReceiver indexContributorReceiver : this._indexContributorReceivers) {
            indexContributorReceiver.removeIndexContributor(indexContributor);
        }
    }

    protected void removeIndexContributorReceiver(IndexContributorReceiver indexContributorReceiver) {
        this._indexContributorReceivers.remove(indexContributorReceiver);
    }
}

