/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexDefinitionData;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexDefinitionsHolder;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexSynchronizer;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.CreateIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch7.spi.index.IndexRegistrar;
import com.liferay.portal.search.elasticsearch7.spi.index.helper.IndexSettingsDefinition;
import com.liferay.portal.search.engine.adapter.index.CreateIndexRequest;
import com.liferay.portal.search.engine.adapter.index.CreateIndexResponse;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchStatusException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IndexSynchronizer.class})
public class IndexSynchronizerImpl
implements IndexSynchronizer {
    private static final Log _log = LogFactoryUtil.getLog(IndexSynchronizerImpl.class);
    private CreateIndexRequestExecutor _createIndexRequestExecutor;
    private IndexDefinitionsHolder _indexDefinitionsHolder;
    private final ArrayList<IndexRegistrar> _indexRegistrarContributors = new ArrayList();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addIndexRegistrar(IndexRegistrar indexRegistrar) {
        this._indexRegistrarContributors.add(indexRegistrar);
    }

    public void removeIndexRegistrar(IndexRegistrar indexRegistrar) {
        this._indexRegistrarContributors.remove(indexRegistrar);
    }

    @Reference(unbind="-")
    public void setIndexDefinitionsHolder(IndexDefinitionsHolder indexDefinitionsHolder) {
        this._indexDefinitionsHolder = indexDefinitionsHolder;
    }

    @Override
    public void synchronizeIndexDefinition(IndexDefinitionData indexDefinitionData) {
        String index = indexDefinitionData.getIndex();
        this.createIndex(index, createIndexRequest -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Synchronizing index " + index));
            }
            createIndexRequest.setSource(indexDefinitionData.getSource());
        });
    }

    @Override
    public void synchronizeIndexes() {
        ArrayList<IndexDefinitionData> list = new ArrayList<IndexDefinitionData>();
        this._indexDefinitionsHolder.drainTo(list);
        list.forEach(this::synchronizeIndexDefinition);
        this._indexRegistrarContributors.forEach(this::synchronizeIndexRegistrar);
    }

    @Override
    public void synchronizeIndexRegistrar(IndexRegistrar indexRegistrar) {
        indexRegistrar.register((indexName, indexSettingsDefinitionConsumer) -> this.createIndex(indexName, createIndexRequest -> indexSettingsDefinitionConsumer.accept(new IndexSettingsDefinition((CreateIndexRequest)createIndexRequest, indexSettingsDefinitionConsumer){
            final /* synthetic */ CreateIndexRequest val$createIndexRequest;
            final /* synthetic */ Consumer val$indexSettingsDefinitionConsumer;
            {
                this.val$createIndexRequest = createIndexRequest;
                this.val$indexSettingsDefinitionConsumer = consumer;
            }

            public void setIndexSettingsResourceName(String indexSettingsResourceName) {
                this.val$createIndexRequest.setSource(StringUtil.read(this.val$indexSettingsDefinitionConsumer.getClass(), (String)indexSettingsResourceName));
            }

            public void setSource(String source) {
                this.val$createIndexRequest.setSource(source);
            }
        })));
    }

    protected void createIndex(String index, Consumer<CreateIndexRequest> createIndexRequestConsumer) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
        createIndexRequestConsumer.accept(createIndexRequest);
        try {
            CreateIndexResponse createIndexResponse = this._createIndexRequestExecutor.execute(createIndexRequest);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Index created: " + createIndexResponse.getIndexName()));
            }
        }
        catch (ElasticsearchStatusException elasticsearchStatusException) {
            String message = elasticsearchStatusException.getMessage();
            if (message != null && message.contains("resource_already_exists_exception")) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping index creation because it already exists: " + createIndexRequest.getIndexName()), (Throwable)elasticsearchStatusException);
                }
            }
            throw elasticsearchStatusException;
        }
    }

    @Reference(unbind="-")
    protected void setCreateIndexRequestExecutor(CreateIndexRequestExecutor createIndexRequestExecutor) {
        this._createIndexRequestExecutor = createIndexRequestExecutor;
    }
}

