/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexDefinitionData;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexSynchronizer;
import com.liferay.portal.search.elasticsearch7.spi.index.IndexRegistrar;
import com.liferay.portal.search.spi.index.IndexDefinition;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={})
public class IndexSynchronizationPortalInitializedListener {
    private static final Log _log = LogFactoryUtil.getLog(IndexSynchronizationPortalInitializedListener.class);
    private boolean _activated;
    private IndexSynchronizer _indexSynchronizer;

    @Activate
    public void activate() {
        this._indexSynchronizer.synchronizeIndexes();
        this._activated = true;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addIndexDefinition(IndexDefinition indexDefinition, Map<String, Object> properties) {
        if (this._activated) {
            this._indexSynchronizer.synchronizeIndexDefinition(new IndexDefinitionData(indexDefinition, properties));
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addIndexRegistrar(IndexRegistrar indexRegistrar) {
        if (this._activated) {
            this._indexSynchronizer.synchronizeIndexRegistrar(indexRegistrar);
        }
    }

    public void removeIndexDefinition(IndexDefinition indexDefinition) {
    }

    public void removeIndexRegistrar(IndexRegistrar indexRegistrar) {
    }

    @Reference(unbind="-")
    public void setIndexSynchronizer(IndexSynchronizer indexSynchronizer) {
        this._indexSynchronizer = indexSynchronizer;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    public void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Portal is initialized and indexes will be synchronized");
        }
    }
}

