/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationObserver;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexFactory;
import com.liferay.portal.search.elasticsearch7.internal.index.LiferayDocumentTypeFactory;
import com.liferay.portal.search.elasticsearch7.internal.index.contributor.IndexContributorReceiver;
import com.liferay.portal.search.elasticsearch7.internal.settings.SettingsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.search.elasticsearch7.internal.util.SearchLogHelperUtil;
import com.liferay.portal.search.elasticsearch7.settings.IndexSettingsHelper;
import com.liferay.portal.search.elasticsearch7.settings.TypeMappingsHelper;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.spi.model.index.contributor.IndexContributor;
import com.liferay.portal.search.spi.settings.IndexSettingsContributor;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={IndexContributorReceiver.class, IndexFactory.class})
public class CompanyIndexFactory
implements ElasticsearchConfigurationObserver,
IndexContributorReceiver,
IndexFactory {
    private static final Log _log = LogFactoryUtil.getLog(CompanyIndexFactory.class);
    private final Set<Long> _companyIds = new HashSet<Long>();
    private volatile ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    private final Set<com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor> _elasticsearchIndexSettingsContributors = new ConcurrentSkipListSet<com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor>();
    private final List<IndexContributor> _indexContributors = new CopyOnWriteArrayList<IndexContributor>();
    private IndexNameBuilder _indexNameBuilder;
    private final Set<IndexSettingsContributor> _indexSettingsContributors = ConcurrentHashMap.newKeySet();
    private JSONFactory _jsonFactory;

    @Override
    public void addIndexContributor(IndexContributor indexContributor) {
        this._indexContributors.add(indexContributor);
    }

    @Override
    public int compareTo(ElasticsearchConfigurationObserver elasticsearchConfigurationObserver) {
        return this._elasticsearchConfigurationWrapper.compare(this, elasticsearchConfigurationObserver);
    }

    @Override
    public void createIndices(IndicesClient indicesClient, long companyId) {
        String indexName = this.getIndexName(companyId);
        if (this.hasIndex(indicesClient, indexName)) {
            return;
        }
        this.createIndex(indexName, indicesClient);
    }

    @Override
    public void deleteIndices(IndicesClient indicesClient, long companyId) {
        String indexName = this.getIndexName(companyId);
        if (!this.hasIndex(indicesClient, indexName)) {
            return;
        }
        this.executeIndexContributorsBeforeRemove(indexName);
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
        try {
            AcknowledgedResponse actionResponse = indicesClient.delete(deleteIndexRequest, RequestOptions.DEFAULT);
            SearchLogHelperUtil.logActionResponse(_log, (ActionResponse)actionResponse);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public void onElasticsearchConfigurationUpdate() {
        this.createCompanyIndexes();
    }

    @Override
    public synchronized void registerCompanyId(long companyId) {
        this._companyIds.add(companyId);
    }

    @Override
    public void removeIndexContributor(IndexContributor indexContributor) {
        this._indexContributors.remove(indexContributor);
    }

    @Override
    public synchronized void unregisterCompanyId(long companyId) {
        this._companyIds.remove(companyId);
    }

    @Activate
    protected void activate() {
        this._elasticsearchConfigurationWrapper.register(this);
        this.createCompanyIndexes();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addElasticsearchIndexSettingsContributor(com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor indexSettingsContributor) {
        this._elasticsearchIndexSettingsContributors.add(indexSettingsContributor);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addIndexSettingsContributor(IndexSettingsContributor indexSettingsContributor) {
        this._indexSettingsContributors.add(indexSettingsContributor);
    }

    protected void addLiferayDocumentTypeMappings(CreateIndexRequest createIndexRequest, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        if (Validator.isNotNull((String)this._elasticsearchConfigurationWrapper.overrideTypeMappings())) {
            liferayDocumentTypeFactory.createLiferayDocumentTypeMappings(createIndexRequest, this._elasticsearchConfigurationWrapper.overrideTypeMappings());
        } else {
            liferayDocumentTypeFactory.createRequiredDefaultTypeMappings(createIndexRequest);
        }
    }

    protected synchronized void createCompanyIndexes() {
        for (Long companyId : this._companyIds) {
            try {
                RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
                this.createIndices(restHighLevelClient.indices(), companyId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to reinitialize index for company " + companyId), (Throwable)exception);
            }
        }
    }

    protected void createIndex(String indexName, IndicesClient indicesClient) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        LiferayDocumentTypeFactory liferayDocumentTypeFactory = new LiferayDocumentTypeFactory(indicesClient, this._jsonFactory);
        this.setSettings(createIndexRequest, liferayDocumentTypeFactory);
        this.addLiferayDocumentTypeMappings(createIndexRequest, liferayDocumentTypeFactory);
        try {
            CreateIndexResponse actionResponse = indicesClient.create(createIndexRequest, RequestOptions.DEFAULT);
            SearchLogHelperUtil.logActionResponse(_log, (ActionResponse)actionResponse);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        this.updateLiferayDocumentType(indexName, liferayDocumentTypeFactory);
        this.executeIndexContributorsAfterCreate(indexName);
    }

    @Deactivate
    protected void deactivate() {
        this._elasticsearchConfigurationWrapper.unregister(this);
    }

    protected void executeIndexContributorAfterCreate(IndexContributor indexContributor, String indexName) {
        try {
            indexContributor.onAfterCreate(indexName);
        }
        catch (Throwable throwable) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to apply contributor ", indexContributor, "to index ", indexName}), throwable);
        }
    }

    protected void executeIndexContributorBeforeRemove(IndexContributor indexContributor, String indexName) {
        try {
            indexContributor.onBeforeRemove(indexName);
        }
        catch (Throwable throwable) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to apply contributor ", indexContributor, " when removing index ", indexName}), throwable);
        }
    }

    protected void executeIndexContributorsAfterCreate(String indexName) {
        for (IndexContributor indexContributor : this._indexContributors) {
            this.executeIndexContributorAfterCreate(indexContributor, indexName);
        }
    }

    protected void executeIndexContributorsBeforeRemove(String indexName) {
        for (IndexContributor indexContributor : this._indexContributors) {
            this.executeIndexContributorBeforeRemove(indexContributor, indexName);
        }
    }

    protected String getIndexName(long companyId) {
        return this._indexNameBuilder.getIndexName(companyId);
    }

    protected boolean hasIndex(IndicesClient indicesClient, String indexName) {
        GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{indexName});
        try {
            return indicesClient.exists(getIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected void loadAdditionalIndexConfigurations(SettingsBuilder settingsBuilder) {
        settingsBuilder.loadFromSource(this._elasticsearchConfigurationWrapper.additionalIndexConfigurations());
    }

    protected void loadAdditionalTypeMappings(String indexName, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        if (Validator.isNull((String)this._elasticsearchConfigurationWrapper.additionalTypeMappings())) {
            return;
        }
        liferayDocumentTypeFactory.addTypeMappings(indexName, this._elasticsearchConfigurationWrapper.additionalTypeMappings());
    }

    protected void loadDefaultIndexSettings(SettingsBuilder settingsBuilder) {
        Settings.Builder builder = settingsBuilder.getBuilder();
        String defaultIndexSettings = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/index-settings-defaults.json");
        builder.loadFromSource(defaultIndexSettings, XContentType.JSON);
    }

    protected void loadIndexConfigurations(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("index.number_of_replicas", this._elasticsearchConfigurationWrapper.indexNumberOfReplicas());
        settingsBuilder.put("index.number_of_shards", this._elasticsearchConfigurationWrapper.indexNumberOfShards());
    }

    protected void loadIndexSettingsContributors(Settings.Builder builder) {
        IndexSettingsHelper elasticsearchIndexSettingsHelper = (setting, value) -> builder.put(setting, value);
        for (com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor indexSettingsContributor : this._elasticsearchIndexSettingsContributors) {
            indexSettingsContributor.populate(elasticsearchIndexSettingsHelper);
        }
        com.liferay.portal.search.spi.settings.IndexSettingsHelper indexSettingsHelper = (setting, value) -> builder.put(setting, value);
        for (IndexSettingsContributor indexSettingsContributor1 : this._indexSettingsContributors) {
            indexSettingsContributor1.populate(indexSettingsHelper);
        }
    }

    protected void loadTestModeIndexSettings(SettingsBuilder settingsBuilder) {
        if (!PortalRunMode.isTestMode()) {
            return;
        }
        settingsBuilder.put("index.refresh_interval", "1ms");
        settingsBuilder.put("index.search.slowlog.threshold.fetch.warn", "-1");
        settingsBuilder.put("index.search.slowlog.threshold.query.warn", "-1");
        settingsBuilder.put("index.translog.sync_interval", "100ms");
    }

    protected void loadTypeMappingsContributors(String indexName, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        for (com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor elasticsearchIndexSettingsContributor : this._elasticsearchIndexSettingsContributors) {
            elasticsearchIndexSettingsContributor.contribute(indexName, (TypeMappingsHelper)liferayDocumentTypeFactory);
        }
        for (IndexSettingsContributor indexSettingsContributor : this._indexSettingsContributors) {
            indexSettingsContributor.contribute(indexName, (com.liferay.portal.search.spi.settings.TypeMappingsHelper)liferayDocumentTypeFactory);
        }
    }

    protected void removeElasticsearchIndexSettingsContributor(com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor indexSettingsContributor) {
        this._elasticsearchIndexSettingsContributors.remove(indexSettingsContributor);
    }

    protected void removeIndexSettingsContributor(IndexSettingsContributor indexSettingsContributor) {
        this._indexSettingsContributors.remove(indexSettingsContributor);
    }

    @Reference(unbind="-")
    protected void setElasticsearchConfigurationWrapper(ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper) {
        this._elasticsearchConfigurationWrapper = elasticsearchConfigurationWrapper;
    }

    @Reference(unbind="-")
    protected void setElasticsearchConnectionManager(ElasticsearchConnectionManager elasticsearchConnectionManager) {
        this._elasticsearchConnectionManager = elasticsearchConnectionManager;
    }

    @Reference(unbind="-")
    protected void setIndexNameBuilder(IndexNameBuilder indexNameBuilder) {
        this._indexNameBuilder = indexNameBuilder;
    }

    @Reference(unbind="-")
    protected void setJsonFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void setSettings(CreateIndexRequest createIndexRequest, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        Settings.Builder builder = Settings.builder();
        liferayDocumentTypeFactory.createRequiredDefaultAnalyzers(builder);
        SettingsBuilder settingsBuilder = new SettingsBuilder(builder);
        this.loadDefaultIndexSettings(settingsBuilder);
        this.loadTestModeIndexSettings(settingsBuilder);
        this.loadIndexConfigurations(settingsBuilder);
        this.loadAdditionalIndexConfigurations(settingsBuilder);
        this.loadIndexSettingsContributors(builder);
        if (Validator.isNotNull((String)builder.get("index.number_of_replicas"))) {
            builder.put("index.auto_expand_replicas", false);
        }
        createIndexRequest.settings(builder);
    }

    protected void updateLiferayDocumentType(String indexName, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        if (Validator.isNotNull((String)this._elasticsearchConfigurationWrapper.overrideTypeMappings())) {
            return;
        }
        this.loadAdditionalTypeMappings(indexName, liferayDocumentTypeFactory);
        this.loadTypeMappingsContributors(indexName, liferayDocumentTypeFactory);
        liferayDocumentTypeFactory.createOptionalDefaultTypeMappings(indexName);
    }
}

