/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={CompositeFacetProcessor.class, FacetProcessor.class})
public class CompositeFacetProcessor
implements FacetProcessor<SearchRequestBuilder> {
    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(class.name=DEFAULT)")
    protected FacetProcessor<SearchRequestBuilder> defaultFacetProcessor;
    private final Map<String, FacetProcessor<SearchRequestBuilder>> _facetProcessors = new HashMap<String, FacetProcessor<SearchRequestBuilder>>();

    @Override
    public Optional<AggregationBuilder> processFacet(Facet facet) {
        Class<?> clazz = facet.getClass();
        FacetProcessor<SearchRequestBuilder> facetProcessor = this._facetProcessors.get(clazz.getName());
        if (facetProcessor == null) {
            facetProcessor = this.defaultFacetProcessor;
        }
        return facetProcessor.processFacet(facet);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(class.name=*)(!(class.name=DEFAULT)))")
    protected void setFacetProcessor(FacetProcessor<SearchRequestBuilder> facetProcessor, Map<String, Object> properties) {
        String className = MapUtil.getString(properties, (String)"class.name");
        this._facetProcessors.put(className, facetProcessor);
    }

    protected void unsetFacetProcessor(FacetProcessor<SearchRequestBuilder> facetProcessor, Map<String, Object> properties) {
        String className = MapUtil.getString(properties, (String)"class.name");
        this._facetProcessors.remove(className);
    }
}

