/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.portal.search.elasticsearch7.internal.util.ClassLoaderUtil;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class RestHighLevelClientFactory {
    private boolean _authenticationEnabled;
    private boolean _httpSSLEnabled;
    private String[] _networkHostAddresses;
    private String _password;
    private String _truststorePassword;
    private String _truststorePath;
    private String _truststoreType;
    private String _userName;

    public static Builder builder() {
        return new Builder();
    }

    public RestHighLevelClient newRestHighLevelClient() {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])this.getHttpHosts()).setHttpClientConfigCallback(this::customizeHttpClient).setRequestConfigCallback(this::customizeRequestConfig);
        return ClassLoaderUtil.getWithContextClassLoader(() -> new RestHighLevelClient(restClientBuilder), this.getClass());
    }

    protected CredentialsProvider createCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this._userName, this._password));
        return credentialsProvider;
    }

    protected SSLContext createSSLContext() {
        try {
            Path path = Paths.get(this._truststorePath, new String[0]);
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            KeyStore keyStore = KeyStore.getInstance(this._truststoreType);
            keyStore.load(inputStream, this._truststorePassword.toCharArray());
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            sslContextBuilder.loadKeyMaterial(keyStore, this._truststorePassword.toCharArray());
            sslContextBuilder.loadTrustMaterial(keyStore, null);
            return sslContextBuilder.build();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
        if (this._authenticationEnabled) {
            httpAsyncClientBuilder.setDefaultCredentialsProvider(this.createCredentialsProvider());
        }
        if (this._httpSSLEnabled) {
            httpAsyncClientBuilder.setSSLContext(this.createSSLContext());
        }
        return httpAsyncClientBuilder;
    }

    protected RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
        return requestConfigBuilder.setSocketTimeout(120000);
    }

    protected HttpHost[] getHttpHosts() {
        return (HttpHost[])Stream.of(this._networkHostAddresses).map(HttpHost::create).toArray(HttpHost[]::new);
    }

    private RestHighLevelClientFactory() {
    }

    private RestHighLevelClientFactory(RestHighLevelClientFactory restHighLevelClientFactory) {
        this._authenticationEnabled = restHighLevelClientFactory._authenticationEnabled;
        this._httpSSLEnabled = restHighLevelClientFactory._httpSSLEnabled;
        this._networkHostAddresses = restHighLevelClientFactory._networkHostAddresses;
        this._password = restHighLevelClientFactory._password;
        this._truststorePassword = restHighLevelClientFactory._truststorePassword;
        this._truststorePath = restHighLevelClientFactory._truststorePath;
        this._truststoreType = restHighLevelClientFactory._truststoreType;
        this._userName = restHighLevelClientFactory._userName;
    }

    static /* synthetic */ String[] access$302(RestHighLevelClientFactory x0, String[] x1) {
        x0._networkHostAddresses = x1;
        return x1;
    }

    public static class Builder {
        private final RestHighLevelClientFactory _restHighLevelClientFactory = new RestHighLevelClientFactory();

        public Builder authenticationEnabled(boolean authenticationEnabled) {
            this._restHighLevelClientFactory._authenticationEnabled = authenticationEnabled;
            return this;
        }

        public RestHighLevelClientFactory build() {
            return new RestHighLevelClientFactory(this._restHighLevelClientFactory);
        }

        public Builder httpSSLEnabled(boolean httpSSLEnabled) {
            this._restHighLevelClientFactory._httpSSLEnabled = httpSSLEnabled;
            return this;
        }

        public Builder networkHostAddresses(String[] networkHostAddresses) {
            RestHighLevelClientFactory.access$302(this._restHighLevelClientFactory, networkHostAddresses);
            return this;
        }

        public Builder password(String password) {
            this._restHighLevelClientFactory._password = password;
            return this;
        }

        public Builder truststorePassword(String truststorePassword) {
            this._restHighLevelClientFactory._truststorePassword = truststorePassword;
            return this;
        }

        public Builder truststorePath(String truststorePath) {
            this._restHighLevelClientFactory._truststorePath = truststorePath;
            return this;
        }

        public Builder truststoreType(String truststoreType) {
            this._restHighLevelClientFactory._truststoreType = truststoreType;
            return this;
        }

        public Builder userName(String userName) {
            this._restHighLevelClientFactory._userName = userName;
            return this;
        }
    }
}

