/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import java.util.Objects;

public class HttpPortRange {
    public static final String AUTO = "AUTO";
    private final String _httpPort;

    public HttpPortRange(ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper) {
        String httpPort;
        this._httpPort = httpPort = HttpPortRange.getHttpPort(elasticsearchConfigurationWrapper);
    }

    public HttpPortRange(String httpPort) {
        this._httpPort = httpPort;
    }

    public String toSettingsString() {
        return this._httpPort;
    }

    protected static String getHttpPort(ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper) {
        String sidecarHttpPort = elasticsearchConfigurationWrapper.sidecarHttpPort();
        if (Objects.equals(sidecarHttpPort, AUTO)) {
            return "9201-9300";
        }
        if (!Validator.isBlank((String)sidecarHttpPort)) {
            return sidecarHttpPort;
        }
        return String.valueOf(elasticsearchConfigurationWrapper.embeddedHttpPort());
    }
}

