/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchInstancePaths;
import com.liferay.portal.search.elasticsearch7.internal.connection.HttpPortRange;
import com.liferay.portal.search.elasticsearch7.internal.settings.SettingsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.search.elasticsearch7.settings.ClientSettingsHelper;
import com.liferay.portal.search.elasticsearch7.settings.SettingsContributor;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;
import org.elasticsearch.common.settings.Settings;

public class ElasticsearchInstanceSettingsBuilder {
    private String _clusterInitialMasterNodes;
    private String _clusterName;
    private String _discoverySeedHosts;
    private boolean _discoveryTypeSingleNode;
    private ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    private ElasticsearchInstancePaths _elasticsearchInstancePaths;
    private HttpPortRange _httpPortRange;
    private Supplier<InetAddress> _localBindInetAddressSupplier;
    private String _networkHost;
    private String _nodeName;
    private final SettingsBuilder _settingsBuilder = new SettingsBuilder(Settings.builder());
    private Collection<SettingsContributor> _settingsContributors;

    public static ElasticsearchInstanceSettingsBuilder builder() {
        return new ElasticsearchInstanceSettingsBuilder();
    }

    public Settings build() {
        this.load();
        Settings.Builder builder = this._settingsBuilder.getBuilder();
        return builder.build();
    }

    public ElasticsearchInstanceSettingsBuilder clusterInitialMasterNodes(String clusterInitialMasterNodes) {
        this._clusterInitialMasterNodes = clusterInitialMasterNodes;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder clusterName(String clusterName) {
        this._clusterName = clusterName;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder discoverySeedHosts(String discoverySeedHosts) {
        this._discoverySeedHosts = discoverySeedHosts;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder discoveryTypeSingleNode(boolean discoveryTypeSingleNode) {
        this._discoveryTypeSingleNode = discoveryTypeSingleNode;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder elasticsearchConfigurationWrapper(ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper) {
        this._elasticsearchConfigurationWrapper = elasticsearchConfigurationWrapper;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder elasticsearchInstancePaths(ElasticsearchInstancePaths elasticsearchInstancePaths) {
        this._elasticsearchInstancePaths = elasticsearchInstancePaths;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder httpPortRange(HttpPortRange httpPortRange) {
        this._httpPortRange = httpPortRange;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder localBindInetAddressSupplier(Supplier<InetAddress> localBindInetAddressSupplier) {
        this._localBindInetAddressSupplier = localBindInetAddressSupplier;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder networkHost(String networkHost) {
        this._networkHost = networkHost;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder nodeName(String nodeName) {
        this._nodeName = nodeName;
        return this;
    }

    public ElasticsearchInstanceSettingsBuilder settingsContributors(Collection<SettingsContributor> settingsContributors) {
        this._settingsContributors = settingsContributors;
        return this;
    }

    protected void configureClustering() {
        this.put("cluster.name", this._clusterName);
        this.put("cluster.routing.allocation.disk.threshold_enabled", false);
        if (!Validator.isBlank((String)this._clusterInitialMasterNodes)) {
            this.put("cluster.initial_master_nodes", this._clusterInitialMasterNodes);
        }
        if (!Validator.isBlank((String)this._discoverySeedHosts)) {
            this.put("discovery.seed_hosts", this._discoverySeedHosts);
        }
        if (this._discoveryTypeSingleNode) {
            this.put("discovery.type", "single-node");
        }
    }

    protected void configureHttp() {
        this.put("http.port", this._httpPortRange.toSettingsString());
        this.put("http.cors.enabled", this._elasticsearchConfigurationWrapper.httpCORSEnabled());
        if (!this._elasticsearchConfigurationWrapper.httpCORSEnabled()) {
            return;
        }
        this.put("http.cors.allow-origin", this._elasticsearchConfigurationWrapper.httpCORSAllowOrigin());
        this._settingsBuilder.loadFromSource(this._elasticsearchConfigurationWrapper.httpCORSConfigurations());
    }

    protected void configureNetworking() {
        String transportTcpPort;
        String networkBindHost = this._elasticsearchConfigurationWrapper.networkBindHost();
        String networkHost = this._elasticsearchConfigurationWrapper.networkHost();
        String networkPublishHost = this._elasticsearchConfigurationWrapper.networkPublishHost();
        if (Validator.isNotNull((String)networkBindHost)) {
            this.put("network.bind.host", networkBindHost);
        }
        if (!Validator.isBlank((String)this._networkHost)) {
            this.put("network.host", this._networkHost);
        } else {
            InetAddress inetAddress;
            if (Validator.isNull((String)networkBindHost) && Validator.isNull((String)networkHost) && Validator.isNull((String)networkPublishHost) && (inetAddress = this._localBindInetAddressSupplier.get()) != null) {
                networkHost = inetAddress.getHostAddress();
            }
            if (Validator.isNotNull((String)networkHost)) {
                this.put("network.host", networkHost);
            }
        }
        if (Validator.isNotNull((String)networkPublishHost)) {
            this.put("network.publish_host", networkPublishHost);
        }
        if (Validator.isNotNull((String)(transportTcpPort = this._elasticsearchConfigurationWrapper.transportTcpPort()))) {
            this.put("transport.port", transportTcpPort);
        }
        this.put("transport.type", "netty4");
    }

    protected void configurePaths() {
        Path workPath = this._elasticsearchInstancePaths.getWorkPath();
        Path dataParentPath = workPath.resolve("data/elasticsearch7");
        Path homePath = this.getHomePath();
        this.put("path.data", String.valueOf(dataParentPath.resolve("indices")));
        this.put("path.home", String.valueOf(homePath.toAbsolutePath()));
        this.put("path.logs", String.valueOf(workPath.resolve("logs")));
        this.put("path.repo", String.valueOf(dataParentPath.resolve("repo")));
    }

    protected void configureTestMode() {
        if (!PortalRunMode.isTestMode()) {
            return;
        }
        this.put("monitor.jvm.gc.enabled", "false");
    }

    protected Path getHomePath() {
        Path homePath = this._elasticsearchInstancePaths.getHomePath();
        if (homePath != null) {
            return homePath;
        }
        Path workPath = this._elasticsearchInstancePaths.getWorkPath();
        return workPath.resolve("data/elasticsearch7");
    }

    protected void load() {
        this.loadDefaultConfigurations();
        this.loadSidecarConfigurations();
        this.loadAdditionalConfigurations();
        this.loadSettingsContributors();
    }

    protected void loadAdditionalConfigurations() {
        this._settingsBuilder.loadFromSource(this._elasticsearchConfigurationWrapper.additionalConfigurations());
    }

    protected void loadDefaultConfigurations() {
        String defaultConfigurations = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/elasticsearch-optional-defaults.yml");
        this._settingsBuilder.loadFromSource(defaultConfigurations);
        this.put("action.auto_create_index", false);
        this.put("bootstrap.memory_lock", this._elasticsearchConfigurationWrapper.bootstrapMlockAll());
        this.configureClustering();
        this.configureHttp();
        this.configureNetworking();
        this.put("node.data", true);
        this.put("node.ingest", true);
        this.put("node.master", true);
        this.put("node.name", this._nodeName);
        this.configurePaths();
        this.configureTestMode();
    }

    protected void loadSettingsContributors() {
        ClientSettingsHelper clientSettingsHelper = new ClientSettingsHelper(){

            public void put(String setting, String value) {
                ElasticsearchInstanceSettingsBuilder.this._settingsBuilder.put(setting, value);
            }

            public void putArray(String setting, String ... values) {
                ElasticsearchInstanceSettingsBuilder.this._settingsBuilder.putList(setting, values);
            }
        };
        for (SettingsContributor settingsContributor : this._settingsContributors) {
            settingsContributor.populate(clientSettingsHelper);
        }
    }

    protected void loadSidecarConfigurations() {
        this.put("bootstrap.system_call_filter", false);
        this.put("node.store.allow_mmap", false);
    }

    protected void put(String key, boolean value) {
        this._settingsBuilder.put(key, value);
    }

    protected void put(String key, String value) {
        this._settingsBuilder.put(key, value);
    }

    public static interface LocalBindInetAddressSupplier
    extends Supplier<InetAddress> {
    }
}

