/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.RestHighLevelClientFactory;
import java.io.IOException;
import java.util.function.Consumer;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticsearchConnection {
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchConnection.class);
    private boolean _active;
    private boolean _authenticationEnabled;
    private String _connectionId;
    private boolean _httpSSLEnabled;
    private String[] _networkHostAddresses;
    private String _password;
    private Runnable _postCloseRunnable;
    private Consumer<ElasticsearchConnection> _preConnectElasticsearchConnectionConsumer;
    private RestHighLevelClient _restHighLevelClient;
    private String _truststorePassword;
    private String _truststorePath;
    private String _truststoreType;
    private String _userName;

    public void close() {
        try {
            if (this._restHighLevelClient == null) {
                return;
            }
            try {
                this._restHighLevelClient.close();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            this._restHighLevelClient = null;
        }
        finally {
            if (this._postCloseRunnable != null) {
                this._postCloseRunnable.run();
            }
        }
    }

    public void connect() {
        if (!this._active && _log.isWarnEnabled()) {
            _log.warn((Object)"Connecting inactive connection");
        }
        if (this._preConnectElasticsearchConnectionConsumer != null) {
            this._preConnectElasticsearchConnectionConsumer.accept(this);
        }
        this._restHighLevelClient = this.createRestHighLevelClient();
    }

    public String getConnectionId() {
        return this._connectionId;
    }

    public RestHighLevelClient getRestHighLevelClient() {
        return this._restHighLevelClient;
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean isConnected() {
        return this._restHighLevelClient != null;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this._authenticationEnabled = authenticationEnabled;
    }

    public void setConnectionId(String connectionId) {
        this._connectionId = connectionId;
    }

    public void setHttpSSLEnabled(boolean httpSSLEnabled) {
        this._httpSSLEnabled = httpSSLEnabled;
    }

    public void setNetworkHostAddresses(String[] networkHostAddresses) {
        this._networkHostAddresses = networkHostAddresses;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setPostCloseRunnable(Runnable postCloseRunnable) {
        this._postCloseRunnable = postCloseRunnable;
    }

    public void setPreConnectElasticsearchConnectionConsumer(Consumer<ElasticsearchConnection> preConnectElasticsearchConnectionConsumer) {
        this._preConnectElasticsearchConnectionConsumer = preConnectElasticsearchConnectionConsumer;
    }

    public void setTruststorePassword(String truststorePassword) {
        this._truststorePassword = truststorePassword;
    }

    public void setTruststorePath(String truststorePath) {
        this._truststorePath = truststorePath;
    }

    public void setTruststoreType(String truststoreType) {
        this._truststoreType = truststoreType;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    protected RestHighLevelClient createRestHighLevelClient() {
        return RestHighLevelClientFactory.builder().authenticationEnabled(this._authenticationEnabled).httpSSLEnabled(this._httpSSLEnabled).networkHostAddresses(this._networkHostAddresses).password(this._password).truststorePassword(this._truststorePassword).truststorePath(this._truststorePath).truststoreType(this._truststoreType).userName(this._userName).build().newRestHighLevelClient();
    }
}

