/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.cluster;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch7.internal.cluster.ClusterSettingsContext;
import com.liferay.portal.search.elasticsearch7.internal.settings.BaseSettingsContributor;
import com.liferay.portal.search.elasticsearch7.settings.ClientSettingsHelper;
import com.liferay.portal.search.elasticsearch7.settings.SettingsContributor;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration"}, enabled=false, immediate=true, property={"operation.mode=EMBEDDED"}, service={SettingsContributor.class})
public class UnicastSettingsContributor
extends BaseSettingsContributor {
    protected volatile ElasticsearchConfiguration elasticsearchConfiguration;
    @Reference
    private ClusterSettingsContext _clusterSettingsContext;

    public UnicastSettingsContributor() {
        super(1);
    }

    public void populate(ClientSettingsHelper clientSettingsHelper) {
        if (!this._clusterSettingsContext.isClusterEnabled()) {
            return;
        }
        clientSettingsHelper.put("cluster.initial_master_nodes", "127.0.0.1");
        clientSettingsHelper.put("discovery.type", "zen");
        clientSettingsHelper.putArray("discovery.zen.ping.unicast.hosts", this._getHosts());
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
    }

    protected void setClusterSettingsContext(ClusterSettingsContext clusterSettingsContext) {
        this._clusterSettingsContext = clusterSettingsContext;
    }

    private String[] _getHosts() {
        String[] hosts = this._clusterSettingsContext.getHosts();
        String port = this.elasticsearchConfiguration.discoveryZenPingUnicastHostsPort();
        port = ':' + port;
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i] + port;
        }
        return hosts;
    }
}

