/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.cluster;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.cluster.ReplicasManager;
import com.liferay.portal.search.elasticsearch7.internal.util.SearchLogHelperUtil;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.settings.Settings;

public class ReplicasManagerImpl
implements ReplicasManager {
    private static final Log _log = LogFactoryUtil.getLog(ReplicasManagerImpl.class);
    private final IndicesClient _indicesClient;

    public ReplicasManagerImpl(IndicesClient indicesClient) {
        this._indicesClient = indicesClient;
    }

    @Override
    public void updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
        block2: {
            UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(indices);
            Settings.Builder builder = Settings.builder();
            builder.put("number_of_replicas", numberOfReplicas);
            updateSettingsRequest.settings(builder);
            try {
                AcknowledgedResponse actionResponse = this._indicesClient.putSettings(updateSettingsRequest, RequestOptions.DEFAULT);
                SearchLogHelperUtil.logActionResponse(_log, (ActionResponse)actionResponse);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to update number of replicas", (Throwable)exception);
            }
        }
    }
}

