/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.cluster;

import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterMasterTokenTransitionListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.cluster.ReplicasClusterContext;
import com.liferay.portal.search.elasticsearch7.internal.cluster.ReplicasManager;

public class ReplicasClusterListener
implements ClusterEventListener,
ClusterMasterTokenTransitionListener {
    private static final Log _log = LogFactoryUtil.getLog(ReplicasClusterListener.class);
    private final ReplicasClusterContext _replicasClusterContext;

    public ReplicasClusterListener(ReplicasClusterContext replicasClusterContext) {
        this._replicasClusterContext = replicasClusterContext;
    }

    public void masterTokenAcquired() {
        this.updateNumberOfReplicas();
    }

    public void masterTokenReleased() {
    }

    public void processClusterEvent(ClusterEvent clusterEvent) {
        if (this._replicasClusterContext.isMaster()) {
            this.updateNumberOfReplicas();
        }
    }

    protected int getNumberOfReplicas() {
        int liferayClusterSize = this._replicasClusterContext.getClusterSize();
        if (liferayClusterSize > 0) {
            return liferayClusterSize - 1;
        }
        return 0;
    }

    protected synchronized void updateNumberOfReplicas() {
        block3: {
            if (!this._replicasClusterContext.isEmbeddedOperationMode()) {
                return;
            }
            try {
                ReplicasManager replicasManager = this._replicasClusterContext.getReplicasManager();
                replicasManager.updateNumberOfReplicas(this.getNumberOfReplicas(), this._replicasClusterContext.getTargetIndexNames());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to update number of replicas", (Throwable)exception);
            }
        }
    }
}

