/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.aggregation.pipeline;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.aggregation.pipeline.AvgBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketMetricsPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketScriptPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketSelectorPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketSortPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.CumulativeSumPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.DerivativePipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.ExtendedStatsBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MaxBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MinBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MovingFunctionPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PercentilesBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationTranslator;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationVisitor;
import com.liferay.portal.search.aggregation.pipeline.SerialDiffPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.StatsBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SumBucketPipelineAggregation;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.pipeline.BucketMetricsPipelineAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.pipeline.GapPolicyTranslator;
import com.liferay.portal.search.elasticsearch7.internal.script.ScriptTranslator;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregatorBuilders;
import org.elasticsearch.search.aggregations.pipeline.BucketScriptPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketSelectorPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketSortPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.CumulativeSumPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.DerivativePipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.ExtendedStatsBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.MovFnPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PercentilesBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.SerialDiffPipelineAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Elasticsearch"}, service={PipelineAggregationTranslator.class, PipelineAggregationVisitor.class})
public class ElasticsearchPipelineAggregationVisitor
implements PipelineAggregationTranslator<PipelineAggregationBuilder>,
PipelineAggregationVisitor<PipelineAggregationBuilder> {
    private final BucketMetricsPipelineAggregationTranslator _bucketMetricsPipelineAggregationTranslator = new BucketMetricsPipelineAggregationTranslator();
    private final GapPolicyTranslator _gapPolicyTranslator = new GapPolicyTranslator();
    private final ScriptTranslator _scriptTranslator = new ScriptTranslator();
    private SortFieldTranslator<?> _sortFieldTranslator;

    public PipelineAggregationBuilder translate(PipelineAggregation pipelineAggregation) {
        return (PipelineAggregationBuilder)pipelineAggregation.accept((PipelineAggregationVisitor)this);
    }

    public PipelineAggregationBuilder visit(AvgBucketPipelineAggregation avgBucketPipelineAggregation) {
        return this._bucketMetricsPipelineAggregationTranslator.translate(bucketMetricsPipelineAggregation -> PipelineAggregatorBuilders.avgBucket((String)bucketMetricsPipelineAggregation.getName(), (String)bucketMetricsPipelineAggregation.getBucketsPath()), (BucketMetricsPipelineAggregation)avgBucketPipelineAggregation);
    }

    public PipelineAggregationBuilder visit(BucketScriptPipelineAggregation bucketScriptPipelineAggregation) {
        BucketScriptPipelineAggregationBuilder bucketScriptPipelineAggregationBuilder = PipelineAggregatorBuilders.bucketScript((String)bucketScriptPipelineAggregation.getName(), (Map)bucketScriptPipelineAggregation.getBucketsPathsMap(), (Script)this._scriptTranslator.translate(bucketScriptPipelineAggregation.getScript()));
        if (bucketScriptPipelineAggregation.getFormat() != null) {
            bucketScriptPipelineAggregationBuilder.format(bucketScriptPipelineAggregation.getFormat());
        }
        return bucketScriptPipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(BucketSelectorPipelineAggregation bucketSelectorPipelineAggregation) {
        BucketSelectorPipelineAggregationBuilder bucketScriptPipelineAggregationBuilder = PipelineAggregatorBuilders.bucketSelector((String)bucketSelectorPipelineAggregation.getName(), (Map)bucketSelectorPipelineAggregation.getBucketsPathsMap(), (Script)this._scriptTranslator.translate(bucketSelectorPipelineAggregation.getScript()));
        if (bucketSelectorPipelineAggregation.getGapPolicy() != null) {
            bucketScriptPipelineAggregationBuilder.gapPolicy(this._gapPolicyTranslator.translate(bucketSelectorPipelineAggregation.getGapPolicy()));
        }
        return bucketScriptPipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(BucketSortPipelineAggregation bucketSortPipelineAggregation) {
        List fieldSorts = bucketSortPipelineAggregation.getFieldSorts();
        ArrayList fieldSortBuilders = new ArrayList(fieldSorts.size());
        fieldSorts.forEach(fieldSort -> {
            FieldSortBuilder fieldSortBuilder = (FieldSortBuilder)this._sortFieldTranslator.translate((Sort)fieldSort);
            fieldSortBuilders.add(fieldSortBuilder);
        });
        BucketSortPipelineAggregationBuilder bucketSortPipelineAggregationBuilder = PipelineAggregatorBuilders.bucketSort((String)bucketSortPipelineAggregation.getName(), fieldSortBuilders);
        if (bucketSortPipelineAggregation.getGapPolicy() != null) {
            bucketSortPipelineAggregationBuilder.gapPolicy(this._gapPolicyTranslator.translate(bucketSortPipelineAggregation.getGapPolicy()));
        }
        if (bucketSortPipelineAggregation.getFrom() != null) {
            bucketSortPipelineAggregationBuilder.from(bucketSortPipelineAggregation.getFrom().intValue());
        }
        if (bucketSortPipelineAggregation.getSize() != null) {
            bucketSortPipelineAggregationBuilder.size(bucketSortPipelineAggregation.getSize());
        }
        return bucketSortPipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(CumulativeSumPipelineAggregation cumulativeSumPipelineAggregation) {
        CumulativeSumPipelineAggregationBuilder cumulativeSumPipelineAggregationBuilder = PipelineAggregatorBuilders.cumulativeSum((String)cumulativeSumPipelineAggregation.getName(), (String)cumulativeSumPipelineAggregation.getBucketsPath());
        if (cumulativeSumPipelineAggregation.getFormat() != null) {
            cumulativeSumPipelineAggregationBuilder.format(cumulativeSumPipelineAggregation.getFormat());
        }
        return cumulativeSumPipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(DerivativePipelineAggregation derivativePipelineAggregation) {
        DerivativePipelineAggregationBuilder derivativePipelineAggregationBuilder = PipelineAggregatorBuilders.derivative((String)derivativePipelineAggregation.getName(), (String)derivativePipelineAggregation.getBucketsPath());
        if (derivativePipelineAggregation.getFormat() != null) {
            derivativePipelineAggregationBuilder.format(derivativePipelineAggregation.getFormat());
        }
        if (derivativePipelineAggregation.getGapPolicy() != null) {
            derivativePipelineAggregationBuilder.gapPolicy(this._gapPolicyTranslator.translate(derivativePipelineAggregation.getGapPolicy()));
        }
        if (derivativePipelineAggregation.getUnit() != null) {
            derivativePipelineAggregationBuilder.unit(derivativePipelineAggregation.getUnit());
        }
        return derivativePipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(ExtendedStatsBucketPipelineAggregation extendedStatsBucketPipelineAggregation) {
        ExtendedStatsBucketPipelineAggregationBuilder extendedStatsBucketPipelineAggregationBuilder = this._bucketMetricsPipelineAggregationTranslator.translate(bucketMetricsPipelineAggregation -> PipelineAggregatorBuilders.extendedStatsBucket((String)bucketMetricsPipelineAggregation.getName(), (String)bucketMetricsPipelineAggregation.getBucketsPath()), (BucketMetricsPipelineAggregation)extendedStatsBucketPipelineAggregation);
        if (extendedStatsBucketPipelineAggregation.getSigma() != null) {
            extendedStatsBucketPipelineAggregationBuilder.sigma(extendedStatsBucketPipelineAggregation.getSigma().doubleValue());
        }
        return extendedStatsBucketPipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(MaxBucketPipelineAggregation maxBucketPipelineAggregation) {
        return this._bucketMetricsPipelineAggregationTranslator.translate(bucketMetricsPipelineAggregation -> PipelineAggregatorBuilders.maxBucket((String)bucketMetricsPipelineAggregation.getName(), (String)bucketMetricsPipelineAggregation.getBucketsPath()), (BucketMetricsPipelineAggregation)maxBucketPipelineAggregation);
    }

    public PipelineAggregationBuilder visit(MinBucketPipelineAggregation minBucketPipelineAggregation) {
        return this._bucketMetricsPipelineAggregationTranslator.translate(bucketMetricsPipelineAggregation -> PipelineAggregatorBuilders.minBucket((String)bucketMetricsPipelineAggregation.getName(), (String)bucketMetricsPipelineAggregation.getBucketsPath()), (BucketMetricsPipelineAggregation)minBucketPipelineAggregation);
    }

    public PipelineAggregationBuilder visit(MovingFunctionPipelineAggregation movingFunctionPipelineAggregation) {
        MovFnPipelineAggregationBuilder movFnPipelineAggregationBuilder = PipelineAggregatorBuilders.movingFunction((String)movingFunctionPipelineAggregation.getName(), (Script)this._scriptTranslator.translate(movingFunctionPipelineAggregation.getScript()), (String)movingFunctionPipelineAggregation.getBucketsPath(), (int)movingFunctionPipelineAggregation.getWindow());
        if (movingFunctionPipelineAggregation.getFormat() != null) {
            movFnPipelineAggregationBuilder.format(movingFunctionPipelineAggregation.getFormat());
        }
        if (movingFunctionPipelineAggregation.getGapPolicy() != null) {
            movFnPipelineAggregationBuilder.gapPolicy(this._gapPolicyTranslator.translate(movingFunctionPipelineAggregation.getGapPolicy()));
        }
        return movFnPipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(PercentilesBucketPipelineAggregation percentilesBucketPipelineAggregation) {
        PercentilesBucketPipelineAggregationBuilder percentilesBucketPipelineAggregationBuilder = this._bucketMetricsPipelineAggregationTranslator.translate(bucketMetricsPipelineAggregation -> PipelineAggregatorBuilders.percentilesBucket((String)bucketMetricsPipelineAggregation.getName(), (String)bucketMetricsPipelineAggregation.getBucketsPath()), (BucketMetricsPipelineAggregation)percentilesBucketPipelineAggregation);
        if (!ArrayUtil.isEmpty((double[])percentilesBucketPipelineAggregation.getPercents())) {
            percentilesBucketPipelineAggregationBuilder.setPercents(percentilesBucketPipelineAggregation.getPercents());
        }
        return percentilesBucketPipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(SerialDiffPipelineAggregation serialDiffPipelineAggregation) {
        SerialDiffPipelineAggregationBuilder serialDiffPipelineAggregationBuilder = PipelineAggregatorBuilders.diff((String)serialDiffPipelineAggregation.getName(), (String)serialDiffPipelineAggregation.getBucketsPath());
        if (serialDiffPipelineAggregation.getFormat() != null) {
            serialDiffPipelineAggregationBuilder.format(serialDiffPipelineAggregation.getFormat());
        }
        if (serialDiffPipelineAggregation.getGapPolicy() != null) {
            serialDiffPipelineAggregationBuilder.gapPolicy(this._gapPolicyTranslator.translate(serialDiffPipelineAggregation.getGapPolicy()));
        }
        if (serialDiffPipelineAggregation.getLag() != null) {
            serialDiffPipelineAggregationBuilder.lag(serialDiffPipelineAggregation.getLag().intValue());
        }
        return serialDiffPipelineAggregationBuilder;
    }

    public PipelineAggregationBuilder visit(StatsBucketPipelineAggregation statsBucketPipelineAggregation) {
        return this._bucketMetricsPipelineAggregationTranslator.translate(bucketMetricsPipelineAggregation -> PipelineAggregatorBuilders.statsBucket((String)bucketMetricsPipelineAggregation.getName(), (String)bucketMetricsPipelineAggregation.getBucketsPath()), (BucketMetricsPipelineAggregation)statsBucketPipelineAggregation);
    }

    public PipelineAggregationBuilder visit(SumBucketPipelineAggregation sumBucketPipelineAggregation) {
        return this._bucketMetricsPipelineAggregationTranslator.translate(bucketMetricsPipelineAggregation -> PipelineAggregatorBuilders.sumBucket((String)bucketMetricsPipelineAggregation.getName(), (String)bucketMetricsPipelineAggregation.getBucketsPath()), (BucketMetricsPipelineAggregation)sumBucketPipelineAggregation);
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setSortFieldTranslator(SortFieldTranslator<?> sortFieldTranslator) {
        this._sortFieldTranslator = sortFieldTranslator;
    }
}

