/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.aggregation.bucket;

import com.liferay.portal.search.aggregation.bucket.Order;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.BucketOrder;

public class OrderTranslator {
    public List<BucketOrder> translate(List<Order> orders) {
        ArrayList<BucketOrder> bucketOrders = new ArrayList<BucketOrder>(orders.size());
        orders.forEach(order -> {
            BucketOrder bucketOrder = this._convert((Order)order);
            bucketOrders.add(bucketOrder);
        });
        return bucketOrders;
    }

    private BucketOrder _convert(Order order) {
        if ("_count".equals(order.getMetricName())) {
            return BucketOrder.count((boolean)order.isAscending());
        }
        if ("_key".equals(order.getMetricName())) {
            return BucketOrder.key((boolean)order.isAscending());
        }
        if (order.getMetricName() == null) {
            return BucketOrder.aggregation((String)order.getPath(), (boolean)order.isAscending());
        }
        return BucketOrder.aggregation((String)order.getPath(), (String)order.getMetricName(), (boolean)order.isAscending());
    }
}

